/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ros.exception.RosMessageRuntimeException;
import org.ros.internal.message.context.MessageContext;
import org.ros.internal.message.field.Field;

public class MessageFields {
    private final Map<String, Field> fields = Maps.newHashMap();
    private final Map<String, Field> setters = Maps.newHashMap();
    private final Map<String, Field> getters = Maps.newHashMap();
    private final List<Field> orderedFields = Lists.newArrayList();

    public MessageFields(MessageContext messageContext) {
        for (String name : messageContext.getFieldNames()) {
            Field field = messageContext.getFieldFactory(name).create();
            this.fields.put(name, field);
            this.getters.put(messageContext.getFieldGetterName(name), field);
            this.setters.put(messageContext.getFieldSetterName(name), field);
            this.orderedFields.add(field);
        }
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    public Field getSetterField(String name) {
        return this.setters.get(name);
    }

    public Field getGetterField(String name) {
        return this.getters.get(name);
    }

    public List<Field> getFields() {
        return Collections.unmodifiableList(this.orderedFields);
    }

    public Object getFieldValue(String name) {
        Field field = this.fields.get(name);
        if (field != null) {
            return field.getValue();
        }
        throw new RosMessageRuntimeException("Uknown field: " + name);
    }

    public void setFieldValue(String name, Object value) {
        Field field = this.fields.get(name);
        if (field == null) {
            throw new RosMessageRuntimeException("Uknown field: " + name);
        }
        field.setValue(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.orderedFields == null ? 0 : this.orderedFields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageFields other = (MessageFields)obj;
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        return !(this.orderedFields == null ? other.orderedFields != null : !this.orderedFields.equals(other.orderedFields));
    }
}

