/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.field.BooleanArrayField;
import org.ros.internal.message.field.ChannelBufferField;
import org.ros.internal.message.field.DoubleArrayField;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;
import org.ros.internal.message.field.FloatArrayField;
import org.ros.internal.message.field.IntegerArrayField;
import org.ros.internal.message.field.ListField;
import org.ros.internal.message.field.LongArrayField;
import org.ros.internal.message.field.ShortArrayField;
import org.ros.internal.message.field.ValueField;
import org.ros.message.Duration;
import org.ros.message.Time;

public enum PrimitiveFieldType implements FieldType
{
    BOOL{

        public Boolean getDefaultValue() {
            return Boolean.FALSE;
        }

        @Override
        public BooleanArrayField newVariableList(String name, int size) {
            return BooleanArrayField.newVariable(name, size);
        }

        @Override
        public int getSerializedSize() {
            return 1;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Boolean));
            buffer.writeByte((int)((byte)((Boolean)value != false ? 1 : 0)));
        }

        public Boolean deserialize(ChannelBuffer buffer) {
            return buffer.readByte() == 1;
        }

        public Boolean parseFromString(String value) {
            return value.equals("1");
        }

        @Override
        public String getJavaTypeName() {
            return "boolean";
        }
    }
    ,
    INT8{

        public Byte getDefaultValue() {
            return (byte)0;
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ChannelBufferField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return 1;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Byte));
            buffer.writeByte((int)((Byte)value).byteValue());
        }

        public Byte deserialize(ChannelBuffer buffer) {
            return buffer.readByte();
        }

        public Byte parseFromString(String value) {
            return Byte.parseByte(value);
        }

        @Override
        public String getJavaTypeName() {
            return "byte";
        }
    }
    ,
    BYTE{

        public Byte getDefaultValue() {
            return (Byte)INT8.getDefaultValue();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ChannelBufferField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return INT8.getSerializedSize();
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            INT8.serialize(value, buffer);
        }

        public Byte deserialize(ChannelBuffer buffer) {
            return (Byte)INT8.deserialize(buffer);
        }

        public Byte parseFromString(String value) {
            return (Byte)INT8.parseFromString(value);
        }

        @Override
        public String getJavaTypeName() {
            return INT8.getJavaTypeName();
        }
    }
    ,
    UINT8{

        public Byte getDefaultValue() {
            return (Byte)INT8.getDefaultValue();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ChannelBufferField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return INT8.getSerializedSize();
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            INT8.serialize(value, buffer);
        }

        public Byte deserialize(ChannelBuffer buffer) {
            return (Byte)INT8.deserialize(buffer);
        }

        public Byte parseFromString(String value) {
            return (byte)Short.parseShort(value);
        }

        @Override
        public String getJavaTypeName() {
            return INT8.getJavaTypeName();
        }
    }
    ,
    CHAR{

        public Byte getDefaultValue() {
            return (Byte)UINT8.getDefaultValue();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ChannelBufferField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return UINT8.getSerializedSize();
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            UINT8.serialize(value, buffer);
        }

        public Byte deserialize(ChannelBuffer buffer) {
            return (Byte)UINT8.deserialize(buffer);
        }

        public Byte parseFromString(String value) {
            return (Byte)UINT8.parseFromString(value);
        }

        @Override
        public String getJavaTypeName() {
            return UINT8.getJavaTypeName();
        }
    }
    ,
    INT16{

        public Short getDefaultValue() {
            return (short)0;
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ShortArrayField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return 2;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Short));
            buffer.writeShort((int)((Short)value).shortValue());
        }

        public Short deserialize(ChannelBuffer buffer) {
            return buffer.readShort();
        }

        public Short parseFromString(String value) {
            return Short.parseShort(value);
        }

        @Override
        public String getJavaTypeName() {
            return "short";
        }
    }
    ,
    UINT16{

        public Short getDefaultValue() {
            return (Short)INT16.getDefaultValue();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ShortArrayField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return INT16.getSerializedSize();
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            INT16.serialize(value, buffer);
        }

        public Short deserialize(ChannelBuffer buffer) {
            return (Short)INT16.deserialize(buffer);
        }

        public Short parseFromString(String value) {
            return (short)Integer.parseInt(value);
        }

        @Override
        public String getJavaTypeName() {
            return INT16.getJavaTypeName();
        }
    }
    ,
    INT32{

        public Integer getDefaultValue() {
            return 0;
        }

        @Override
        public Field newVariableList(String name, int size) {
            return IntegerArrayField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return 4;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Integer));
            buffer.writeInt(((Integer)value).intValue());
        }

        public Integer deserialize(ChannelBuffer buffer) {
            return buffer.readInt();
        }

        public Integer parseFromString(String value) {
            return Integer.parseInt(value);
        }

        @Override
        public String getJavaTypeName() {
            return "int";
        }
    }
    ,
    UINT32{

        public Integer getDefaultValue() {
            return (Integer)INT32.getDefaultValue();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return IntegerArrayField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return INT32.getSerializedSize();
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            INT32.serialize(value, buffer);
        }

        public Integer deserialize(ChannelBuffer buffer) {
            return (Integer)INT32.deserialize(buffer);
        }

        public Integer parseFromString(String value) {
            return (int)Long.parseLong(value);
        }

        @Override
        public String getJavaTypeName() {
            return INT32.getJavaTypeName();
        }
    }
    ,
    INT64{

        public Long getDefaultValue() {
            return 0L;
        }

        @Override
        public Field newVariableList(String name, int size) {
            return LongArrayField.newVariable(this, name, size);
        }

        @Override
        public int getSerializedSize() {
            return 8;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Long));
            buffer.writeLong(((Long)value).longValue());
        }

        public Long deserialize(ChannelBuffer buffer) {
            return buffer.readLong();
        }

        public Long parseFromString(String value) {
            return Long.parseLong(value);
        }

        @Override
        public String getJavaTypeName() {
            return "long";
        }
    }
    ,
    UINT64{

        public Long getDefaultValue() {
            return (Long)INT64.getDefaultValue();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return INT64.newVariableList(name, size);
        }

        @Override
        public int getSerializedSize() {
            return INT64.getSerializedSize();
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            INT64.serialize(value, buffer);
        }

        public Long deserialize(ChannelBuffer buffer) {
            return (Long)INT64.deserialize(buffer);
        }

        public Long parseFromString(String value) {
            return (Long)INT64.parseFromString(value);
        }

        @Override
        public String getJavaTypeName() {
            return INT64.getJavaTypeName();
        }
    }
    ,
    FLOAT32{

        public Float getDefaultValue() {
            return Float.valueOf(0.0f);
        }

        @Override
        public Field newVariableList(String name, int size) {
            return FloatArrayField.newVariable(name, size);
        }

        @Override
        public int getSerializedSize() {
            return 4;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Float));
            buffer.writeFloat(((Float)value).floatValue());
        }

        public Float deserialize(ChannelBuffer buffer) {
            return Float.valueOf(buffer.readFloat());
        }

        public Float parseFromString(String value) {
            return Float.valueOf(Float.parseFloat(value));
        }

        @Override
        public String getJavaTypeName() {
            return "float";
        }
    }
    ,
    FLOAT64{

        public Double getDefaultValue() {
            return 0.0;
        }

        @Override
        public int getSerializedSize() {
            return 8;
        }

        @Override
        public Field newVariableList(String name, int size) {
            return DoubleArrayField.newVariable(name, size);
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Double));
            buffer.writeDouble(((Double)value).doubleValue());
        }

        public Double deserialize(ChannelBuffer buffer) {
            return buffer.readDouble();
        }

        public Double parseFromString(String value) {
            return Double.parseDouble(value);
        }

        @Override
        public String getJavaTypeName() {
            return "double";
        }
    }
    ,
    STRING{

        public String getDefaultValue() {
            return "";
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ListField.newVariable(this, name);
        }

        @Override
        public int getSerializedSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof String));
            byte[] bytes = ((String)value).getBytes();
            buffer.writeInt(bytes.length);
            buffer.writeBytes(bytes);
        }

        public String deserialize(ChannelBuffer buffer) {
            int length = buffer.readInt();
            ByteBuffer stringBuffer = buffer.readSlice(length).toByteBuffer();
            return Charset.forName("US-ASCII").decode(stringBuffer).toString();
        }

        public String parseFromString(String value) {
            return value;
        }

        @Override
        public String getJavaTypeName() {
            return "java.lang.String";
        }
    }
    ,
    TIME{

        public Time getDefaultValue() {
            return new Time();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ListField.newVariable(this, name);
        }

        @Override
        public int getSerializedSize() {
            return 8;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Time));
            buffer.writeInt(((Time)value).secs);
            buffer.writeInt(((Time)value).nsecs);
        }

        public Time deserialize(ChannelBuffer buffer) {
            return new Time(buffer.readInt(), buffer.readInt());
        }

        public Void parseFromString(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getJavaTypeName() {
            return Time.class.getName();
        }
    }
    ,
    DURATION{

        public Duration getDefaultValue() {
            return new Duration();
        }

        @Override
        public Field newVariableList(String name, int size) {
            return ListField.newVariable(this, name);
        }

        @Override
        public int getSerializedSize() {
            return 8;
        }

        @Override
        public <T> void serialize(T value, ChannelBuffer buffer) {
            Preconditions.checkArgument((boolean)(value instanceof Duration));
            buffer.writeInt(((Duration)value).secs);
            buffer.writeInt(((Duration)value).nsecs);
        }

        public Duration deserialize(ChannelBuffer buffer) {
            return new Duration(buffer.readInt(), buffer.readInt());
        }

        public Void parseFromString(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getJavaTypeName() {
            return Duration.class.getName();
        }
    };

    private static final ImmutableSet<String> TYPE_NAMES;

    public static boolean existsFor(String name) {
        return TYPE_NAMES.contains((Object)name);
    }

    @Override
    public Field newVariableValue(String name) {
        return ValueField.newVariable(this, name);
    }

    @Override
    public <T> Field newConstantValue(String name, T value) {
        return ValueField.newConstant(this, name, value);
    }

    @Override
    public String getName() {
        return this.toString().toLowerCase();
    }

    @Override
    public String getMd5String() {
        return this.getName();
    }

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PrimitiveFieldType type : PrimitiveFieldType.values()) {
            builder.add((Object)type.getName());
        }
        TYPE_NAMES = builder.build();
    }
}

