/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.field;

import com.google.common.base.Preconditions;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.internal.message.field.Field;
import org.ros.internal.message.field.FieldType;

class ValueField<T>
extends Field {
    private T value;

    static <T> ValueField<T> newConstant(FieldType type, String name, T value) {
        return new ValueField<T>(type, name, value, true);
    }

    static <T> ValueField<T> newVariable(FieldType type, String name) {
        return new ValueField<Object>(type, name, null, false);
    }

    private ValueField(FieldType type, String name, T value, boolean isConstant) {
        super(type, name, isConstant);
        this.value = value;
    }

    @Override
    public T getValue() {
        if (this.value == null) {
            this.setValue(this.type.getDefaultValue());
        }
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkState((!this.isConstant ? 1 : 0) != 0);
        this.value = value;
    }

    @Override
    public void serialize(ChannelBuffer buffer) {
        this.type.serialize(this.getValue(), buffer);
    }

    @Override
    public void deserialize(ChannelBuffer buffer) {
        Preconditions.checkState((!this.isConstant ? 1 : 0) != 0);
        this.setValue(this.type.deserialize(buffer));
    }

    @Override
    public String getMd5String() {
        return String.format("%s %s\n", this.type, this.name);
    }

    @Override
    public String getJavaTypeName() {
        return this.type.getJavaTypeName();
    }

    public String toString() {
        return "ValueField<" + this.type + ", " + this.name + ">";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Field other = (Field)obj;
        return !(this.getValue() == null ? other.getValue() != null : !this.getValue().equals(other.getValue()));
    }
}

