/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.service;

import java.util.List;
import org.ros.internal.message.definition.MessageDefinitionTupleParser;
import org.ros.message.MessageDeclaration;
import org.ros.message.MessageIdentifier;

public class ServiceDescription
extends MessageDeclaration {
    private final String requestType;
    private final String requestDefinition;
    private final String responseType;
    private final String responseDefinition;
    private final String md5Checksum;

    public ServiceDescription(String type, String definition, String md5Checksum) {
        super(MessageIdentifier.of(type), definition);
        this.md5Checksum = md5Checksum;
        List<String> requestAndResponse = MessageDefinitionTupleParser.parse(definition, 2);
        this.requestType = type + "Request";
        this.responseType = type + "Response";
        this.requestDefinition = requestAndResponse.get(0);
        this.responseDefinition = requestAndResponse.get(1);
    }

    public String getMd5Checksum() {
        return this.md5Checksum;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getRequestDefinition() {
        return this.requestDefinition;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getResponseDefinition() {
        return this.responseDefinition;
    }

    @Override
    public String toString() {
        return "ServiceDescription<" + this.getType() + ", " + this.md5Checksum + ">";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.md5Checksum == null ? 0 : this.md5Checksum.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceDescription other = (ServiceDescription)obj;
        return !(this.md5Checksum == null ? other.md5Checksum != null : !this.md5Checksum.equals(other.md5Checksum));
    }
}

