/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.message.topic;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import org.ros.internal.message.StringResourceProvider;
import org.ros.message.MessageDefinitionProvider;
import org.ros.message.MessageIdentifier;

public class TopicDefinitionResourceProvider
implements MessageDefinitionProvider {
    private final StringResourceProvider stringResourceProvider = new StringResourceProvider();

    private String topicTypeToResourceName(String topicType) {
        MessageIdentifier messageIdentifier = MessageIdentifier.of(topicType);
        return String.format("/%s/msg/%s.msg", messageIdentifier.getPackage(), messageIdentifier.getName());
    }

    @Override
    public String get(String topicType) {
        return this.stringResourceProvider.get(this.topicTypeToResourceName(topicType));
    }

    @Override
    public boolean has(String topicType) {
        return this.stringResourceProvider.has(this.topicTypeToResourceName(topicType));
    }

    @VisibleForTesting
    public void add(String topicType, String topicDefinition) {
        this.stringResourceProvider.addStringToCache(this.topicTypeToResourceName(topicType), topicDefinition);
    }

    @Override
    public Collection<String> getPackages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<MessageIdentifier> getMessageIdentifiersByPackage(String pkg) {
        throw new UnsupportedOperationException();
    }
}

