/*
 * Decompiled with CFR 0.152.
 */
package org.ros.message;

import com.google.common.base.Preconditions;

public class MessageIdentifier {
    private String type;
    private String pkg;
    private String name;

    public static MessageIdentifier of(String pkg, String name) {
        Preconditions.checkNotNull((Object)pkg);
        Preconditions.checkNotNull((Object)name);
        return new MessageIdentifier(pkg, name);
    }

    public static MessageIdentifier of(String type) {
        Preconditions.checkNotNull((Object)type);
        if (!type.contains("/")) {
            throw new IllegalArgumentException(String.format("Type name is invalid or not fully qualified: \"%s\"", type));
        }
        return new MessageIdentifier(type);
    }

    private MessageIdentifier(String type) {
        this.type = type;
    }

    private MessageIdentifier(String pkg, String name) {
        this.pkg = pkg;
        this.name = name;
    }

    public String getType() {
        if (this.type == null) {
            StringBuilder stringBuilder = new StringBuilder(this.pkg.length() + this.name.length() + 1);
            stringBuilder.append(this.pkg);
            stringBuilder.append("/");
            stringBuilder.append(this.name);
            this.type = stringBuilder.toString();
        }
        return this.type;
    }

    private void splitType() {
        String[] packageAndName = this.type.split("/", 2);
        this.pkg = packageAndName[0];
        this.name = packageAndName[1];
    }

    public String getPackage() {
        if (this.pkg == null) {
            this.splitType();
        }
        return this.pkg;
    }

    public String getName() {
        if (this.name == null) {
            this.splitType();
        }
        return this.name;
    }

    public String toString() {
        return String.format("MessageIdentifier<%s>", this.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageIdentifier other = (MessageIdentifier)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

