/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2se;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

public class UniversalFilterInputStream
extends InputStream {
    protected InputStream in;
    protected boolean marked = false;
    protected Connection con;
    protected OutputStream log;

    public UniversalFilterInputStream(InputStream in) {
        this.in = new BufferedInputStream(in);
        if (in.markSupported()) {
            try {
                in.mark(in.available());
                this.marked = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public UniversalFilterInputStream(Connection con, InputStream in) {
        this(in);
        this.con = con;
    }

    public UniversalFilterInputStream(Connection con, InputStream in, String logURL) throws IOException {
        this(con, in);
        this.log = Connector.openOutputStream((String)logURL);
    }

    @Override
    public int read() throws IOException {
        try {
            int b = this.in.read();
            if (this.log != null) {
                this.log.write(b);
                this.log.flush();
            }
            return b;
        }
        catch (SocketTimeoutException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int count = this.in.read(b, off, len);
            if (this.log != null && count != -1) {
                this.log.write(b, off, count);
                this.log.flush();
            }
            return count;
        }
        catch (SocketTimeoutException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.in.skip(n);
        }
        catch (SocketTimeoutException e) {
            throw new InterruptedIOException();
        }
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        if (this.con != null) {
            this.con.close();
        }
        if (this.log != null) {
            this.log.close();
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.marked = false;
        this.in.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    public void seek(long pos) throws IOException, IllegalAccessException {
        try {
            if (!this.marked) {
                throw new IllegalAccessException();
            }
            this.in.reset();
            this.in.skip((int)pos);
        }
        catch (SocketTimeoutException e) {
            throw new InterruptedIOException();
        }
    }
}

