/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2se;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;

public class UniversalFilterOutputStream
extends OutputStream {
    protected OutputStream out;
    protected Connection con;
    protected OutputStream log;

    public UniversalFilterOutputStream(OutputStream out) {
        this.out = out;
    }

    public UniversalFilterOutputStream(Connection con, OutputStream out) {
        this.out = new BufferedOutputStream(out);
        this.con = con;
    }

    public UniversalFilterOutputStream(Connection con, OutputStream out, String logURL) throws IOException {
        this(con, out);
        this.log = Connector.openOutputStream((String)logURL);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.log != null) {
            this.log.write(b);
            this.log.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b, 0, b.length);
        if (this.log != null) {
            this.log.write(b, 0, b.length);
            this.log.flush();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.log != null) {
            this.log.write(b, off, len);
            this.log.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        if (this.log != null) {
            this.log.flush();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out.close();
        if (this.con != null) {
            this.con.close();
        }
        if (this.log != null) {
            this.log.close();
        }
    }
}

