/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2se.file;

import com.sun.squawk.io.ConnectionBase;
import com.sun.squawk.io.j2se.ParameterParser;
import com.sun.squawk.io.j2se.UniversalFilterInputStream;
import com.sun.squawk.io.j2se.UniversalFilterOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBase
implements StreamConnection {
    InputStream fis;
    OutputStream fos;

    public Connection open(String protocol, String name, int mode, boolean timeouts) throws IOException {
        block19: {
            String fileName = name;
            if (fileName.length() >= 2 && (fileName.charAt(0) != '/' || fileName.charAt(1) != '/')) {
                throw new IllegalArgumentException("Protocol must start with \"//\" " + fileName);
            }
            class Parameters
            extends ParameterParser {
                boolean append;
                Vector<String> path = new Vector();

                Parameters() {
                }

                @Override
                public boolean parameter(String key, String value) {
                    if (key.equals("append")) {
                        this.append = value.equals("true");
                    } else if (key.equals("pathelement")) {
                        this.path.add(value);
                    } else {
                        return false;
                    }
                    return true;
                }
            }
            Parameters p = new Parameters();
            fileName = p.parse(fileName.substring(2));
            try {
                if (mode == 1) {
                    if (fileName.endsWith("/")) {
                        this.fis = this.getListingFor(fileName);
                    } else if (p.path.size() == 0 || new File(fileName).isAbsolute()) {
                        this.fis = new FileInputStream(fileName);
                    } else {
                        boolean found = false;
                        for (String path : p.path) {
                            try {
                                File file = new File(path, fileName);
                                this.fis = new FileInputStream(file);
                                found = true;
                                break;
                            }
                            catch (IOException e) {
                            }
                        }
                        if (!found) {
                            throw new IOException();
                        }
                    }
                    break block19;
                }
                if (mode == 2) {
                    if (p.path.size() == 0 || new File(fileName).isAbsolute()) {
                        this.fos = new FileOutputStream(fileName, p.append);
                    } else {
                        boolean found = false;
                        for (String path : p.path) {
                            try {
                                this.fos = new FileOutputStream(new File(path, fileName), p.append);
                                found = true;
                                break;
                            }
                            catch (IOException e) {
                            }
                        }
                        if (!found) {
                            throw new IOException();
                        }
                    }
                    break block19;
                }
                throw new IllegalArgumentException("Bad mode");
            }
            catch (IOException ex) {
                throw new ConnectionNotFoundException(name);
            }
        }
        return this;
    }

    private InputStream getListingFor(String dirName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.getListingForPrim(dirName, dos, dirName.endsWith("//"));
        dos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private void getListingForPrim(String dirName, DataOutputStream dos, boolean recursive) throws IOException {
        File dir = new File(dirName.replace('/', File.separatorChar));
        File[] files = dir.listFiles();
        if (files == null) {
            throw new ConnectionNotFoundException(dirName);
        }
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (!f.isDirectory()) {
                dos.writeUTF(f.getPath().replace('\\', '/'));
                continue;
            }
            if (!recursive) continue;
            this.getListingForPrim(f.getPath(), dos, recursive);
        }
    }

    public InputStream openInputStream() throws IOException {
        if (this.fis == null) {
            throw new IllegalArgumentException("Bad mode");
        }
        UniversalFilterInputStream res = new UniversalFilterInputStream((Connection)this, this.fis);
        this.fis = null;
        return new BufferedInputStream(res);
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.fos == null) {
            throw new IllegalArgumentException("Bad mode");
        }
        UniversalFilterOutputStream res = new UniversalFilterOutputStream((Connection)this, this.fos);
        this.fos = null;
        return res;
    }

    public void close() throws IOException {
    }
}

