/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.io.j2se.zip;

import com.sun.squawk.io.ConnectionBase;
import com.sun.squawk.io.j2se.UniversalFilterInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.StreamConnection;

public class Protocol
extends ConnectionBase
implements StreamConnection {
    InputStream is;
    ZipFile z;
    int opens = 0;

    public void open(String name, int mode, boolean timeouts) throws IOException {
        throw new RuntimeException("Should not be called");
    }

    public Connection open(String protocol, String name, int mode, boolean timeouts) throws IOException {
        if (name.charAt(0) != '/' || name.charAt(1) != '/') {
            throw new IllegalArgumentException("Protocol must start with \"//\" " + name);
        }
        int index = (name = name.substring(2)).indexOf(64);
        if (index == -1) {
            throw new IllegalArgumentException("Bad zip protocol: " + name);
        }
        String zipname = name.substring(0, index);
        String filename = name.substring(index + 1);
        if (mode == 1) {
            try {
                if (name.endsWith("/")) {
                    this.is = this.getListingFor(zipname, filename);
                }
                this.z = new ZipFile(zipname);
                ZipEntry e = this.z.getEntry(filename);
                if (e != null) {
                    this.is = this.z.getInputStream(e);
                }
                throw new ConnectionNotFoundException(name);
            }
            catch (IOException ex) {
                throw new ConnectionNotFoundException(name);
            }
        } else {
            throw new IllegalArgumentException("Bad mode");
        }
        ++this.opens;
        return this;
    }

    private InputStream getListingFor(String zipName, String fileName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        boolean recursive = fileName.endsWith("//");
        if (recursive) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        if (fileName.equals("/")) {
            fileName = "";
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipName);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry zipEntry = e.nextElement();
                String name = zipEntry.getName();
                if (!name.startsWith(fileName) || name.charAt(name.length() - 1) == '/' || !recursive && name.indexOf(47, fileName.length()) != -1) continue;
                dos.writeUTF(name);
            }
        }
        catch (IOException ioe) {
            throw new ConnectionNotFoundException(zipName);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ex) {}
            }
        }
        dos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public InputStream openInputStream() throws IOException {
        if (this.is == null) {
            throw new IllegalArgumentException("Bad mode");
        }
        UniversalFilterInputStream res = new UniversalFilterInputStream((Connection)this, this.is);
        this.is = null;
        ++this.opens;
        return res;
    }

    public OutputStream openOutputStream() throws IOException {
        throw new IllegalArgumentException("Bad mode");
    }

    public void close() throws IOException {
        if (this.opens > 0) {
            --this.opens;
            if (this.opens == 0 && this.z != null) {
                this.z.close();
            }
        }
    }
}

