/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.util.LongHashtableEntry;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class LongHashtable {
    private transient LongHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private static final int loadFactorPercent = 75;

    public LongHashtable(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.table = new LongHashtableEntry[initialCapacity];
        this.threshold = initialCapacity * 75 / 100;
    }

    public LongHashtable() {
        this(11);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new HashtableEnumerator(this.table, true);
    }

    public Enumeration elements() {
        return new HashtableEnumerator(this.table, false);
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        LongHashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            LongHashtableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        LongHashtableEntry[] tab = this.table;
        int index = ((int)key & Integer.MAX_VALUE) % tab.length;
        LongHashtableEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object get(long key) {
        LongHashtableEntry[] tab = this.table;
        int index = ((int)key & Integer.MAX_VALUE) % tab.length;
        LongHashtableEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        LongHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        LongHashtableEntry[] newTable = new LongHashtableEntry[newCapacity];
        this.threshold = newCapacity * 75 / 100;
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            LongHashtableEntry old = oldTable[i];
            while (old != null) {
                LongHashtableEntry e = old;
                old = old.next;
                int index = ((int)e.key & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public Object put(long key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        LongHashtableEntry[] tab = this.table;
        int index = ((int)key & Integer.MAX_VALUE) % tab.length;
        LongHashtableEntry e = tab[index];
        while (e != null) {
            if (e.key == key) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = ((int)key & Integer.MAX_VALUE) % tab.length;
        }
        e = new LongHashtableEntry();
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
        return null;
    }

    public Object remove(long key) {
        LongHashtableEntry[] tab = this.table;
        int index = ((int)key & Integer.MAX_VALUE) % tab.length;
        LongHashtableEntry e = tab[index];
        LongHashtableEntry prev = null;
        while (e != null) {
            if (e.key == key) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public void clear() {
        LongHashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        for (int i = 0; i <= max; ++i) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(s1 + "=" + s2);
            if (i >= max) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    static class HashtableEnumerator
    implements Enumeration {
        boolean keys;
        int index;
        LongHashtableEntry[] table;
        LongHashtableEntry entry;

        HashtableEnumerator(LongHashtableEntry[] table, boolean keys) {
            this.table = table;
            this.keys = keys;
            this.index = table.length;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                LongHashtableEntry e = this.entry;
                this.entry = e.next;
                return this.keys ? new Long(e.key) : e.value;
            }
            throw new NoSuchElementException("HashtableEnumerator");
        }
    }
}

