/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.util.IntHashtable;
import com.sun.squawk.util.IntHashtableEntry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableIntHashtable
extends IntHashtable
implements Serializable {
    public SerializableIntHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public SerializableIntHashtable() {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.count = in.readInt();
        this.threshold = in.readInt();
        int tableLength = in.readInt();
        this.table = new IntHashtableEntry[tableLength];
        for (int i = 0; i < tableLength; ++i) {
            IntHashtableEntry entry = null;
            while (in.readBoolean()) {
                IntHashtableEntry nextEntry = new IntHashtableEntry();
                nextEntry.key = in.readInt();
                nextEntry.value = in.readObject();
                if (entry == null) {
                    this.table[i] = nextEntry;
                    entry = nextEntry;
                    continue;
                }
                entry.next = nextEntry;
                entry = nextEntry;
            }
        }
        this.rehash();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.count);
        out.writeInt(this.threshold);
        int tableLength = this.table.length;
        out.writeInt(tableLength);
        for (int i = 0; i < tableLength; ++i) {
            IntHashtableEntry entry = this.table[i];
            while (entry != null) {
                out.writeBoolean(true);
                out.writeInt(entry.key);
                out.writeObject(entry.value);
                entry = entry.next;
            }
            out.writeBoolean(false);
        }
    }
}

