/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.vm;

import com.sun.squawk.util.Assert;
import com.sun.squawk.util.SerializableIntHashtable;
import com.sun.squawk.vm.Channel;
import com.sun.squawk.vm.EventQueue;
import com.sun.squawk.vm.GUIInputChannel;
import com.sun.squawk.vm.GUIOutputChannel;
import com.sun.squawk.vm.GenericConnectionChannel;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class ChannelIO
implements Serializable {
    private static SerializableIntHashtable contexts = new SerializableIntHashtable();
    private static int nextContext = 1;
    private int context;
    private boolean rundown;
    private SerializableIntHashtable channels = new SerializableIntHashtable();
    private int nextAvailableChannelID = 4;
    private GUIInputChannel guiInputChannel = new GUIInputChannel(this, 2);
    private GUIOutputChannel guiOutputChannel = new GUIOutputChannel(this, 3, this.guiInputChannel);
    private String exceptionClassName;
    private long theResult;
    static final boolean TRACING_ENABLED = System.getProperty("cio.tracing", "false").equals("true");
    static final boolean LOGGING_ENABLED = System.getProperty("cio.logging", "false").equals("true");
    transient byte[] hibernationData;
    private static boolean DEBUG = false;
    private static int timing = 0;

    static void trace(String msg) {
        System.out.println(msg);
    }

    public static int execute(int context, int op, int channel, int i1, int i2, int i3, int i4, int i5, int i6, Object o1, Object o2) {
        if (context == -1) {
            switch (op) {
                case 2: {
                    return EventQueue.getEvent();
                }
                case 3: {
                    EventQueue.sendNotify();
                    return 0;
                }
                case 4: {
                    long time = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
                    EventQueue.waitFor(time);
                    return 0;
                }
                case 1: {
                    if (contexts.get(1) == null) {
                        ChannelIO cio = ChannelIO.createCIO((byte[])o1);
                        int index = 1;
                        contexts.put(index, cio);
                        cio.context = index;
                    }
                    return 1;
                }
            }
            throw Assert.shouldNotReachHere((String)("Unknown global IO operation opcode: " + op));
        }
        ChannelIO cio = (ChannelIO)contexts.get(context);
        if (cio == null) {
            return -1;
        }
        int result = cio.execute(op, channel, i1, i2, i3, i4, i5, i6, o1, o2);
        return result;
    }

    int getCIOIndex() {
        return this.context;
    }

    private static ChannelIO deserialize(byte[] serializedData) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(serializedData);
        ObjectInputStream ois = new ObjectInputStream(in);
        ChannelIO cio = (ChannelIO)ois.readObject();
        in.close();
        return cio;
    }

    private static ChannelIO createCIO(byte[] serializedData) {
        if (serializedData != null) {
            try {
                ChannelIO cio = ChannelIO.deserialize(serializedData);
                cio.rundown = false;
                cio.guiInputChannel.addToGUIInputQueue(0, 0, 0, 0);
                return cio;
            }
            catch (Exception ex) {
                System.err.println("Error deserializing channel " + ex);
            }
        }
        if (TRACING_ENABLED) {
            ChannelIO.trace("new channel for isolate");
        }
        return new ChannelIO();
    }

    private ChannelIO() {
        this.channels.put(2, this.guiInputChannel);
        this.channels.put(3, this.guiOutputChannel);
    }

    GenericConnectionChannel createGenericConnectionChannel() {
        while (this.channels.get(this.nextAvailableChannelID) != null) {
            ++this.nextAvailableChannelID;
        }
        int channelID = this.nextAvailableChannelID++;
        GenericConnectionChannel channel = new GenericConnectionChannel(this, channelID);
        this.channels.put(channelID, channel);
        if (TRACING_ENABLED) {
            ChannelIO.trace("++createGenericConnectionChannel = " + channel);
        }
        return channel;
    }

    private int execute(int op, int channelID, int i1, int i2, int i3, int i4, int i5, int i6, Object o1, Object o2) {
        int status;
        if (TRACING_ENABLED) {
            // empty if block
        }
        if (this.rundown) {
            if (TRACING_ENABLED) {
                ChannelIO.trace("execute status = javax.microedition.io.ConnectionNotFoundException");
            }
            return this.raiseException("IsolateRundownError");
        }
        switch (op) {
            case 10: {
                return (int)this.theResult;
            }
            case 11: {
                return (int)(this.theResult >>> 32);
            }
            case 12: {
                return this.getError();
            }
            case 8: {
                switch (i1) {
                    case 2: 
                    case 3: {
                        return i1;
                    }
                    case 1: {
                        return this.createGenericConnectionChannel().getChannelID();
                    }
                }
                return -3;
            }
            case 9: {
                Channel channel = (Channel)this.channels.get(channelID);
                if (channel != null) {
                    channel.close();
                }
                this.channels.remove(channelID);
                return 0;
            }
            case 7: {
                if (this.hibernationData != null) {
                    System.arraycopy(this.hibernationData, 0, o2, 0, i2);
                }
                this.hibernationData = null;
                return 0;
            }
            case 6: {
                this.hibernationData = new byte[0];
                if (this.hibernationData != null) {
                    return this.hibernationData.length;
                }
                return -2;
            }
            case 5: {
                return 0;
            }
        }
        Channel channel = (Channel)this.channels.get(channelID);
        if (channel == null) {
            if (TRACING_ENABLED) {
                ChannelIO.trace("execute status = javax.microedition.io.ConnectionNotFoundException");
            }
            return this.raiseException("javax.microedition.io.ConnectionNotFoundException");
        }
        channel.clearResult();
        try {
            status = channel.execute(op, i1, i2, i3, i4, i5, i6, o1, o2);
        }
        catch (Throwable ex) {
            status = this.raiseException(ex.toString());
        }
        this.theResult = channel.getResult();
        if (TRACING_ENABLED) {
            ChannelIO.trace("execute status = " + status);
        }
        return status;
    }

    private int getError() {
        if (this.exceptionClassName != null) {
            char ch = this.exceptionClassName.charAt(0);
            int length = this.exceptionClassName.length();
            this.exceptionClassName = length == 1 ? null : this.exceptionClassName.substring(1);
            return ch;
        }
        return 0;
    }

    private void close() {
        if (!this.rundown) {
            this.rundown = true;
            Enumeration e = this.channels.elements();
            while (e.hasMoreElements()) {
                Channel channel = (Channel)e.nextElement();
                if (channel == null) continue;
                channel.close();
            }
            if (TRACING_ENABLED) {
                ChannelIO.trace("++close ");
            }
        }
    }

    private byte[] hibernate() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            return baos.toByteArray();
        }
        catch (Throwable t) {
            System.err.println("Error serializing channel: " + t);
            t.printStackTrace();
            this.raiseException(t.getClass().getName());
            return null;
        }
    }

    private int raiseException(String exceptionClassName) {
        if (exceptionClassName.length() == 0) {
            exceptionClassName = "?raiseException?";
        }
        this.exceptionClassName = exceptionClassName;
        return -2;
    }

    void unblock(int event) {
        EventQueue.unblock(event);
    }

    private static void usage(String errMsg) {
        PrintStream out = System.out;
        if (errMsg != null) {
            out.println(errMsg);
        }
        out.println("Usage: ChannelIO [-options]");
        out.println("where options include:");
        out.println();
        out.println("    -port:<port>  the port to listen on (default=9090)");
        out.println("    -d            run in debug mode");
        out.println("    -t<n>         show timing info every 'n' IO operations");
        out.println();
    }

    public static void main(String[] args) {
        int port = 9090;
        for (int argc = 0; argc != args.length; ++argc) {
            String arg = args[argc];
            if (arg.startsWith("-port:")) {
                port = Integer.parseInt(arg.substring("-port:".length()));
                continue;
            }
            if (arg.equals("-d")) {
                DEBUG = true;
                continue;
            }
            if (arg.startsWith("-t")) {
                timing = Integer.parseInt(arg.substring(2));
                continue;
            }
            ChannelIO.usage("Unknown option: " + arg);
            System.exit(1);
        }
        try {
            System.out.println("Starting server on port " + port);
            StreamConnectionNotifier ssocket = (StreamConnectionNotifier)Connector.open((String)("serversocket://:" + port));
            IOTimeInfo timingInfo = null;
            if (timing != 0) {
                timingInfo = new IOTimeInfo();
            }
            while (true) {
                try {
                    if (DEBUG) {
                        System.out.println("listening on port " + port);
                    }
                    StreamConnection con = ssocket.acceptAndOpen();
                    if (DEBUG) {
                        System.out.println("Got connection");
                    }
                    DataInputStream in = con.openDataInputStream();
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(con.openOutputStream()));
                    while (true) {
                        int high;
                        long start = 0L;
                        long end = 0L;
                        if (timing != 0) {
                            start = System.currentTimeMillis();
                        }
                        if (DEBUG) {
                            System.err.print("IO server receiving: ");
                        }
                        int cio = ChannelIO.readInt(in, "cio");
                        int op = ChannelIO.readInt(in, "op");
                        int cid = ChannelIO.readInt(in, "cid");
                        int i1 = ChannelIO.readInt(in, "i1");
                        int i2 = ChannelIO.readInt(in, "i2");
                        int i3 = ChannelIO.readInt(in, "i3");
                        int i4 = ChannelIO.readInt(in, "i4");
                        int i5 = ChannelIO.readInt(in, "i5");
                        int i6 = ChannelIO.readInt(in, "i6");
                        int retLth = ChannelIO.readInt(in, "lth");
                        Object s1 = ChannelIO.readObject(in);
                        if (timing != 0) {
                            end = System.currentTimeMillis();
                            timingInfo.receive += end - start;
                            start = end;
                        }
                        if (DEBUG) {
                            System.err.println();
                        }
                        byte[] buf = new byte[retLth];
                        int status = -1;
                        try {
                            status = ChannelIO.execute(cio, op, cid, i1, i2, i3, i4, i5, i6, s1, buf);
                        }
                        catch (Throwable ex) {
                            System.err.println("Exception cause in I/O server " + ex);
                            buf = new byte[]{};
                        }
                        int low = cio == -1 ? -1 : ChannelIO.execute(cio, 10, -1, 0, 0, 0, 0, 0, 0, null, null);
                        int n = high = cio == -1 ? -1 : ChannelIO.execute(cio, 11, -1, 0, 0, 0, 0, 0, 0, null, null);
                        if (timing != 0) {
                            end = System.currentTimeMillis();
                            timingInfo.execute += end - start;
                            start = end;
                        }
                        if (DEBUG) {
                            System.err.print("IO server sending: ");
                        }
                        ChannelIO.writeInt(out, "magic", -889275714);
                        ChannelIO.writeInt(out, "status", status);
                        ChannelIO.writeInt(out, "r-low ", low);
                        ChannelIO.writeInt(out, "r-high", high);
                        ChannelIO.writeInt(out, "resLth", buf.length);
                        out.write(buf);
                        out.flush();
                        if (timing == 0) continue;
                        end = System.currentTimeMillis();
                        timingInfo.send += end - start;
                        ++timingInfo.count;
                        if (timingInfo.count % timing != 0) continue;
                        timingInfo.dump(System.err);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
    }

    private static int readInt(DataInputStream in, String name) throws IOException {
        int val = in.readInt();
        if (DEBUG) {
            System.err.print(name + "=" + val + " ");
        }
        return val;
    }

    private static void writeInt(DataOutputStream out, String name, int val) throws IOException {
        out.writeInt(val);
        if (DEBUG) {
            System.err.print(name + "=" + val + " ");
        }
    }

    private static Object readObject(DataInputStream in) throws IOException {
        int cno = in.readInt();
        int lth = in.readInt();
        if (cno == 0) {
            return null;
        }
        if (cno == 19 || cno == 26) {
            Object object;
            byte[] buf = new byte[lth];
            in.readFully(buf);
            if (cno == 19) {
                object = buf;
            } else {
                String string;
                object = string;
                string = new String(buf);
            }
            return object;
        }
        if (cno == 20 || cno == 2) {
            Object object;
            char[] buf = new char[lth];
            for (int i = 0; i < lth; ++i) {
                buf[i] = in.readChar();
            }
            if (cno == 20) {
                object = buf;
            } else {
                String string;
                object = string;
                string = new String(buf);
            }
            return object;
        }
        if (cno == 22) {
            int[] buf = new int[lth];
            for (int i = 0; i < lth; ++i) {
                buf[i] = in.readInt();
            }
            return buf;
        }
        System.err.println("Bad object type " + cno);
        return null;
    }

    static class IOTimeInfo {
        long execute;
        long receive;
        long send;
        int count;

        IOTimeInfo() {
        }

        void dump(PrintStream out) {
            long total = this.receive + this.execute + this.send;
            out.println("average time per IO operation: ");
            out.println("    receive: " + this.receive / (long)this.count + "ms");
            out.println("    send:    " + this.send / (long)this.count + "ms");
            out.println("    execute: " + this.execute / (long)this.count + "ms");
            out.println("    total:   " + total / (long)this.count + "ms");
        }
    }
}

