/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.vm;

import com.sun.squawk.vm.Channel;
import com.sun.squawk.vm.ChannelIO;
import java.util.Vector;

public class GUIInputChannel
extends Channel {
    private static final boolean TRACING_ENABLED = ChannelIO.TRACING_ENABLED;
    final Vector inputQueue = new Vector();
    private boolean blocked;

    public GUIInputChannel(ChannelIO cio, int channelID) {
        super(cio, channelID);
        if (channelID != 2) {
            throw new RuntimeException("The GUI input channel must have identifier 2");
        }
    }

    @Override
    synchronized int execute(int op, int i1, int i2, int i3, int i4, int i5, int i6, Object o1, Object o2) {
        switch (op) {
            case 22: {
                if (this.inputQueue.size() == 0) {
                    this.blocked = true;
                    return this.getEventNumber();
                }
                Long event = (Long)this.inputQueue.firstElement();
                this.inputQueue.removeElementAt(0);
                this.result = event;
                if (!TRACING_ENABLED) break;
                ChannelIO.trace("execute result = " + this.result);
                break;
            }
            default: {
                throw new RuntimeException("Illegal channel operation " + op);
            }
        }
        return 0;
    }

    private void unblock() {
        if (this.blocked) {
            this.blocked = false;
            this.result = 0L;
            this.cio.unblock(this.getEventNumber());
        }
    }

    synchronized void addToGUIInputQueue(int key1_high, int key1_low, int key2_high, int key2_low) {
        long key1 = key1_high << 16 | key1_low & 0xFFFF;
        long key2 = key2_high << 16 | key2_low & 0xFFFF;
        long event = key1 << 32 | key2 & 0xFFFFFFFFL;
        if (TRACING_ENABLED) {
            this.traceGUIEvent(event);
        }
        this.inputQueue.addElement(new Long(event));
        this.unblock();
    }

    @Override
    public void close() {
        this.unblock();
    }

    private void traceGUIEvent(long result) {
        int key1 = (int)(result >> 32);
        int key2 = (int)result;
        int key1_H = key1 >> 16 & 0xFFFF;
        int key1_L = key1 & 0xFFFF;
        int key2_H = key2 >> 16 & 0xFFFF;
        int key2_L = key2 & 0xFFFF;
        ChannelIO.trace("[" + this.cio.getCIOIndex() + "] " + key1_H + ":" + key1_L + ":" + key2_H + ":" + key2_L);
    }
}

