/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.vm;

import com.sun.squawk.util.SerializableIntHashtable;
import com.sun.squawk.vm.Channel;
import com.sun.squawk.vm.ChannelIO;
import com.sun.squawk.vm.FileImageHandle;
import com.sun.squawk.vm.FontMetricsHandle;
import com.sun.squawk.vm.GUIInputChannel;
import com.sun.squawk.vm.HibernateDialog;
import com.sun.squawk.vm.ImageHandle;
import com.sun.squawk.vm.MemoryImageHandle;
import com.sun.squawk.vm.RGBImageHandle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class GUIOutputChannel
extends Channel
implements FocusListener,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final int VERTICAL_FRAME_MARGIN = 28;
    private static final int HORIZONTAL_FRAME_MARGIN = 8;
    private static final boolean isHeadless = System.getProperty("java.awt.headless", "false").equals("true");
    private static final boolean TRACING_ENABLED;
    private final GUIInputChannel guiInputChannel;
    private final SerializableIntHashtable fonts = new SerializableIntHashtable();
    private final SerializableIntHashtable images = new SerializableIntHashtable();
    private String mainClassName = "?";
    private int nextImageNumber = 0;
    private transient Frame frame;
    private Dimension frameSize = new Dimension(300, 300);
    private Point frameLocation;
    private transient Panel panel;
    private transient Graphics display;
    private transient Image offScreenBuffer;
    private transient Graphics offScreenDisplay;
    private transient MediaTracker mediaTracker;
    private boolean offScreen = false;
    private static Point nextFrameLocation;

    public GUIOutputChannel(ChannelIO cio, int index, GUIInputChannel guiInputChannel) {
        super(cio, index);
        this.guiInputChannel = guiInputChannel;
    }

    private void initializeGraphics() {
        if (TRACING_ENABLED) {
            ChannelIO.trace("setupGraphics " + this.frameSize);
        }
        this.frame = new Frame(this.mainClassName);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (TRACING_ENABLED) {
                    ChannelIO.trace("bye...");
                }
                GUIOutputChannel.this.addEvent(3, 0, 0, 0);
            }
        });
        this.panel = new Panel(){

            @Override
            public void paint(Graphics g) {
                GUIOutputChannel.this.addEvent(0, 0, 0, 0);
            }
        };
        if (this.frameLocation == null) {
            this.frameLocation = new Point(nextFrameLocation);
        }
        this.panel.addKeyListener(this);
        this.panel.addMouseListener(this);
        this.panel.addMouseMotionListener(this);
        this.frame.addFocusListener(this);
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                GUIOutputChannel.this.frameLocation = GUIOutputChannel.this.frame.getLocation();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension size = GUIOutputChannel.this.frame.getSize();
                GUIOutputChannel.this.frameSize = new Dimension(size.width - 8, size.height - 28);
            }
        });
        this.frame.setLocation(this.frameLocation);
        this.frame.setSize(this.frameSize.width + 8, this.frameSize.height + 28);
        this.frame.add(this.panel);
        this.frame.setVisible(true);
        this.display = this.panel.getGraphics();
        this.mediaTracker = new MediaTracker(this.panel);
        int nextFrameX = this.frame.getX() + this.frame.getWidth() + 8;
        int nextFrameY = this.frame.getY();
        if (nextFrameX >= 1024) {
            nextFrameX %= nextFrameX;
            if ((nextFrameY += this.frame.getHeight() + 28) >= 768) {
                nextFrameY %= 768;
            }
        }
        nextFrameLocation = new Point(nextFrameX, nextFrameY);
    }

    private Graphics getGraphics() {
        if (isHeadless) {
            throw new RuntimeException("cannot get a Graphics object in a headless graphics environment");
        }
        if (this.display == null) {
            this.initializeGraphics();
        }
        if (this.offScreen && this.offScreenBuffer == null) {
            this.panel.setBackground(Color.black);
            this.offScreenBuffer = this.panel.createImage(this.frame.getWidth(), this.frame.getHeight());
            this.offScreenDisplay = this.offScreenBuffer.getGraphics();
            this.offScreenDisplay.setColor(Color.blue);
            this.offScreenDisplay.fillRect(0, 0, this.frame.getWidth(), this.frame.getHeight());
        }
        if (this.offScreen) {
            return this.offScreenDisplay;
        }
        return this.display;
    }

    private MediaTracker getMediaTracker() {
        if (this.mediaTracker == null) {
            this.getGraphics();
        }
        return this.mediaTracker;
    }

    private FontMetrics getFontMetrics(int fontID) {
        try {
            return ((FontMetricsHandle)this.fonts.get(fontID)).getFontMetrics();
        }
        catch (NullPointerException e) {
            throw new RuntimeException("attempt to retrieve non-existing font: " + fontID);
        }
    }

    void flushScreen() {
        if (this.offScreen && this.display != null && this.offScreenBuffer != null) {
            this.display.drawImage(this.offScreenBuffer, 0, 0, this.panel);
            if (TRACING_ENABLED) {
                ChannelIO.trace("**flushScreen**");
            }
        }
    }

    @Override
    public void close() {
        if (this.frame != null) {
            Frame temp = this.frame;
            temp.dispose();
            this.frame = null;
            this.panel = null;
            this.display = null;
            this.offScreenBuffer = null;
            this.offScreenDisplay = null;
            this.mediaTracker = null;
        }
    }

    @Override
    int execute(int op, int i1, int i2, int i3, int i4, int i5, int i6, Object o1, Object o2) {
        try {
            switch (op) {
                case 37: {
                    String s;
                    this.mainClassName = s = (String)o1;
                    break;
                }
                case 38: {
                    this.result = this.frameSize.width;
                    break;
                }
                case 39: {
                    this.result = this.frameSize.height;
                    break;
                }
                case 40: {
                    Toolkit.getDefaultToolkit().beep();
                    break;
                }
                case 41: {
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("setOffScreenMode");
                    }
                    this.offScreen = true;
                    break;
                }
                case 42: {
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("setOnScreen");
                    }
                    this.flushScreen();
                    break;
                }
                case 43: {
                    byte[] buf = (byte[])o1;
                    MemoryImageHandle imageHandle = new MemoryImageHandle(buf);
                    this.result = this.nextImageNumber++;
                    this.images.put((int)this.result, imageHandle);
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("createImage " + this.result);
                    }
                    break;
                }
                case 44: {
                    int hs = i1;
                    int vs = i2;
                    int rgbLength = i3;
                    int stride = i4;
                    RGBImageHandle rgbImageHandle = new RGBImageHandle(hs, vs, rgbLength, stride);
                    this.result = this.nextImageNumber++;
                    this.images.put((int)this.result, rgbImageHandle);
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("createMemoryImage " + this.result);
                    }
                    break;
                }
                case 45: {
                    String s = (String)o1;
                    FileImageHandle fileImageHandle = new FileImageHandle(s);
                    this.result = this.nextImageNumber++;
                    this.images.put((int)this.result, fileImageHandle);
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("getImage " + this.result + " " + s);
                    }
                    break;
                }
                case 46: {
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("imageWidth");
                    }
                    int index = i1;
                    ImageHandle imageHandle = (ImageHandle)this.images.get(index);
                    Image image = imageHandle.getImage(this.getMediaTracker());
                    this.result = image.getWidth(null);
                    break;
                }
                case 47: {
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("imageHeight");
                    }
                    int index = i1;
                    ImageHandle imageHandle = (ImageHandle)this.images.get(index);
                    Image image = imageHandle.getImage(this.getMediaTracker());
                    this.result = image.getHeight(null);
                    break;
                }
                case 48: {
                    int index = i1;
                    int x = i2;
                    int y = i3;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("drawImage0 " + index + " at " + x + ":" + y);
                    }
                    if (!isHeadless) {
                        ImageHandle imageHandle = (ImageHandle)this.images.get(index);
                        Image image = imageHandle.getImage(this.getMediaTracker());
                        this.getGraphics().drawImage(image, x, y, null);
                    }
                    break;
                }
                case 49: {
                    int index = i1;
                    int[] rgb = (int[])o1;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("flush0 " + index + " " + rgb);
                    }
                    if (!isHeadless) {
                        RGBImageHandle rgbImageHandle = (RGBImageHandle)this.images.get(index);
                        rgbImageHandle.getImage(this.getMediaTracker());
                        rgbImageHandle.flush(rgb);
                    }
                    break;
                }
                case 50: {
                    int size = i1;
                    boolean isBold = i2 != 0;
                    int fontID = (size << 16) + (isBold ? 1 : 0);
                    if (!this.fonts.containsKey(fontID)) {
                        FontMetricsHandle handle = new FontMetricsHandle(isBold, size);
                        this.fonts.put(fontID, handle);
                    }
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("createFontMetrics " + fontID);
                    }
                    this.result = fontID;
                    break;
                }
                case 51: {
                    int fontID = i1;
                    String s = (String)o1;
                    this.result = this.getFontMetrics(fontID).stringWidth(s);
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fontStringWidth " + fontID + ":" + s + " = " + this.result);
                    }
                    break;
                }
                case 52: {
                    int fontID = i1;
                    this.result = this.getFontMetrics(fontID).getHeight();
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fontGetHeight " + fontID + " = " + this.result);
                    }
                    break;
                }
                case 53: {
                    int fontID = i1;
                    this.result = this.getFontMetrics(fontID).getAscent();
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fontGetHeight " + fontID + " = " + this.result);
                    }
                    break;
                }
                case 54: {
                    int fontID = i1;
                    this.result = this.getFontMetrics(fontID).getDescent();
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fontGetHeight " + fontID + " = " + this.result);
                    }
                    break;
                }
                case 55: {
                    int fontID = i1;
                    FontMetrics metrics = this.getFontMetrics(fontID);
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("setFont0 " + metrics.getFont());
                    }
                    if (!isHeadless) {
                        this.getGraphics().setFont(metrics.getFont());
                    }
                    break;
                }
                case 56: {
                    int c = i1;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("setColor0 " + c);
                    }
                    if (!isHeadless) {
                        this.getGraphics().setColor(new Color(c));
                    }
                    break;
                }
                case 57: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("setClip0 " + x + ":" + y + ":" + w + ":" + h);
                    }
                    if (!isHeadless) {
                        this.getGraphics().setClip(x, y, w, h);
                    }
                    break;
                }
                case 58: {
                    String s = (String)o1;
                    int x = i1;
                    int y = i2;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("drawString0 \"" + s + "\" " + x + ":" + y);
                    }
                    if (!isHeadless) {
                        this.getGraphics().drawString(s, x, y);
                    }
                    break;
                }
                case 59: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("drawLine0 " + x + ":" + y + ":" + w + ":" + h);
                    }
                    if (!isHeadless) {
                        this.getGraphics().drawLine(x, y, w, h);
                    }
                    break;
                }
                case 60: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("drawOval0 " + x + ":" + y + ":" + w + ":" + h);
                    }
                    if (!isHeadless) {
                        this.getGraphics().drawOval(x, y, w, h);
                    }
                    break;
                }
                case 61: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("drawRect0 " + x + ":" + y + ":" + w + ":" + h);
                    }
                    if (!isHeadless) {
                        this.getGraphics().drawRect(x, y, w, h);
                    }
                    break;
                }
                case 62: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fillRect0 " + x + ":" + y + ":" + w + ":" + h);
                    }
                    if (!isHeadless) {
                        this.getGraphics().fillRect(x, y, w, h);
                    }
                    break;
                }
                case 63: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    int aw = i5;
                    int ah = i6;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("drawRoundRect0 " + x + ":" + y + ":" + w + ":" + h + ":" + aw + ":" + ah);
                    }
                    if (!isHeadless) {
                        this.getGraphics().drawRoundRect(x, y, w, h, aw, ah);
                    }
                    break;
                }
                case 64: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    int aw = i5;
                    int ah = i6;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fillRoundRect0 " + x + ":" + y + ":" + w + ":" + h + ":" + aw + ":" + ah);
                    }
                    if (!isHeadless) {
                        this.getGraphics().fillRoundRect(x, y, w, h, aw, ah);
                    }
                    break;
                }
                case 65: {
                    int x = i1;
                    int y = i2;
                    int w = i3;
                    int h = i4;
                    int ba = i5;
                    int ea = i6;
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fillArc0 " + x + ":" + y + ":" + w + ":" + h + ":" + ba + ":" + ea);
                    }
                    if (!isHeadless) {
                        this.getGraphics().fillArc(x, y, w, h, ba, ea);
                    }
                    break;
                }
                case 66: {
                    int i;
                    int[] comb = (int[])o1;
                    int count = i1;
                    int[] x = new int[comb.length / 2];
                    int[] y = new int[comb.length / 2];
                    for (i = 0; i < x.length; ++i) {
                        x[i] = comb[i];
                    }
                    for (i = 0; i < y.length; ++i) {
                        y[i] = comb[x.length + i];
                    }
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("fillPolygon0 " + count);
                    }
                    if (!isHeadless) {
                        this.getGraphics().fillPolygon(x, y, count);
                    }
                    break;
                }
                case 67: {
                    if (TRACING_ENABLED) {
                        ChannelIO.trace("repaint0");
                    }
                    if (!isHeadless) {
                        this.panel.repaint();
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal channel operation " + op);
                }
            }
        }
        catch (VirtualMachineError ie) {
            String message = ie.getMessage();
            if (message.indexOf("X11") != -1 || message.indexOf("DISPLAY") != -1) {
                ie.printStackTrace();
            }
            throw ie;
        }
        return 0;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.panel.requestFocus();
        this.flushScreen();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    void addEvent(int key1_high, int key1_low, int key2_high, int key2_low) {
        this.guiInputChannel.addToGUIInputQueue(key1_high, key1_low, key2_high, key2_low);
    }

    private void traceKeyEvent(String action, KeyEvent e) {
        ChannelIO.trace(action + " " + e.getKeyCode() + ":" + e.getKeyChar());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (TRACING_ENABLED) {
            this.traceKeyEvent("keyPressed", e);
        }
        if (e.getKeyCode() >= 32) {
            this.addEvent(1, e.getID(), e.getKeyCode(), e.getKeyChar());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (TRACING_ENABLED) {
            this.traceKeyEvent("keyTyped", e);
        }
        if (e.getKeyChar() >= ' ') {
            this.addEvent(1, e.getID(), e.getKeyCode(), e.getKeyChar());
        } else {
            this.addEvent(1, 401, e.getKeyChar(), e.getKeyChar());
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (TRACING_ENABLED) {
            this.traceKeyEvent("keyReleased", e);
        }
        this.addEvent(1, e.getID(), e.getKeyCode(), e.getKeyChar());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (TRACING_ENABLED) {
            ChannelIO.trace("mousePressed " + e);
        }
        if (e.getButton() == 1 && (e.getModifiers() & 2) == 0) {
            this.addEvent(2, e.getID(), e.getX(), e.getY());
        } else {
            new HibernateDialog(this.frame, this.guiInputChannel);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (TRACING_ENABLED) {
            ChannelIO.trace("mouseReleased " + e);
        }
        if (e.getButton() == 1) {
            this.addEvent(2, e.getID(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (TRACING_ENABLED) {
            ChannelIO.trace("mouseClicked " + e);
        }
        if (e.getButton() == 1) {
            this.addEvent(2, e.getID(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (TRACING_ENABLED) {
            ChannelIO.trace("mouseDragged " + e);
        }
        this.addEvent(2, e.getID(), e.getX(), e.getY());
    }

    static {
        if (isHeadless) {
            System.out.println("[Running in headless graphics environment]");
        }
        TRACING_ENABLED = ChannelIO.TRACING_ENABLED;
        nextFrameLocation = new Point(10, 10);
    }
}

