/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.vm;

import com.sun.squawk.vm.Acceptor;
import com.sun.squawk.vm.Channel;
import com.sun.squawk.vm.ChannelIO;
import com.sun.squawk.vm.DataSucker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import javax.microedition.io.StreamConnection;

public class GenericConnectionChannel
extends Channel {
    private static boolean NON_BLOCKING_INPUT = true;
    Connection con;
    private String conProtocolAndName;
    private DataInputStream dis;
    PushbackInputStream pbis;
    boolean eofSeen = false;
    IOException pendingException;
    StreamConnection acceptConnection;
    private DataOutputStream dos;
    private DataOutputStream inLog;
    private DataOutputStream outLog;

    public GenericConnectionChannel(ChannelIO cio, int channelID) {
        super(cio, channelID);
        if (ChannelIO.LOGGING_ENABLED) {
            try {
                this.inLog = new DataOutputStream(new FileOutputStream("channel" + channelID + ".input"));
                this.outLog = new DataOutputStream(new FileOutputStream("channel" + channelID + ".output"));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void throwPendingException() throws IOException {
        IOException ex = this.pendingException;
        this.pendingException = null;
        if (ex != null) {
            throw ex;
        }
    }

    private boolean available(int n) throws IOException {
        if (!NON_BLOCKING_INPUT) {
            return true;
        }
        this.throwPendingException();
        if (this.eofSeen || n <= this.dis.available()) {
            return true;
        }
        new DataSucker(this, n).start();
        return false;
    }

    @Override
    int execute(int op, int i1, int i2, int i3, int i4, int i5, int i6, Object o1, Object o2) throws IOException {
        switch (op) {
            case 13: {
                this.conProtocolAndName = (String)o1;
                int mode = i1;
                int tmo = i2;
                this.con = Connector.open((String)this.conProtocolAndName, (int)mode, (tmo == 1 ? 1 : 0) != 0);
                break;
            }
            case 14: {
                this.con.close();
                this.con = null;
                break;
            }
            case 15: {
                this.throwPendingException();
                if (this.acceptConnection == null) {
                    new Acceptor(this).start();
                    return this.getEventNumber();
                }
                GenericConnectionChannel channel = this.cio.createGenericConnectionChannel();
                channel.con = this.acceptConnection;
                this.acceptConnection = null;
                this.result = channel.getChannelID();
                break;
            }
            case 16: {
                InputStream is = ((InputConnection)this.con).openInputStream();
                this.pbis = new PushbackInputStream(is, 8);
                this.dis = new DataInputStream(this.pbis);
                break;
            }
            case 17: {
                this.dis.close();
                this.dis = null;
                break;
            }
            case 19: {
                if (!this.available(1)) {
                    return this.getEventNumber();
                }
                this.result = this.dis.read();
                if (this.inLog == null) break;
                this.inLog.writeByte((int)this.result);
                break;
            }
            case 20: {
                if (!this.available(2)) {
                    return this.getEventNumber();
                }
                this.result = this.dis.readShort();
                if (this.inLog == null) break;
                this.inLog.writeShort((int)this.result);
                break;
            }
            case 21: {
                if (!this.available(4)) {
                    return this.getEventNumber();
                }
                this.result = this.dis.readInt();
                if (this.inLog == null) break;
                this.inLog.writeInt((int)this.result);
                break;
            }
            case 22: {
                if (!this.available(8)) {
                    return this.getEventNumber();
                }
                this.result = this.dis.readLong();
                if (this.inLog == null) break;
                this.inLog.writeLong(this.result);
                break;
            }
            case 23: {
                if (!this.available(1)) {
                    return this.getEventNumber();
                }
                int off = i1;
                int len = Math.min(i2, this.dis.available());
                byte[] buf = (byte[])o2;
                this.result = this.dis.read(buf, off, len);
                if (this.inLog == null) break;
                for (int i = off; i < off + len; ++i) {
                    this.inLog.writeByte(buf[i]);
                }
                break;
            }
            case 24: {
                long l = ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
                this.result = this.dis.skip(l);
                break;
            }
            case 25: {
                this.result = this.dis.available();
                break;
            }
            case 26: {
                int limit = i1;
                this.dis.mark(limit);
                break;
            }
            case 27: {
                this.dis.reset();
                break;
            }
            case 28: {
                this.result = this.dis.markSupported() ? 1L : 0L;
                break;
            }
            case 29: {
                this.dos = ((OutputConnection)this.con).openDataOutputStream();
                break;
            }
            case 30: {
                this.dos.flush();
                break;
            }
            case 31: {
                this.dos.close();
                this.dos = null;
                break;
            }
            case 32: {
                int ch = i1;
                this.dos.write(ch);
                this.dos.flush();
                if (this.outLog == null) break;
                this.outLog.writeByte(ch);
                break;
            }
            case 33: {
                int val = i1;
                this.dos.writeShort(val);
                this.dos.flush();
                if (this.outLog == null) break;
                this.outLog.writeShort(val);
                break;
            }
            case 34: {
                int val = i1;
                this.dos.writeInt(val);
                this.dos.flush();
                if (this.outLog == null) break;
                this.outLog.writeInt(val);
                break;
            }
            case 35: {
                long l = ((long)i1 << 32) + ((long)i2 & 0xFFFFFFFFL);
                this.dos.writeLong(l);
                this.dos.flush();
                if (this.outLog == null) break;
                this.outLog.writeLong(l);
                break;
            }
            case 36: {
                byte[] buf = (byte[])o1;
                int off = i1;
                int len = i2;
                this.dos.write(buf, off, len);
                this.dos.flush();
                if (this.outLog == null) break;
                for (int i = off; i < off + len; ++i) {
                    this.outLog.writeByte(buf[i]);
                }
                break;
            }
            default: {
                throw new RuntimeException("Invalid channel opcode: " + op);
            }
        }
        return 0;
    }

    @Override
    public void close() {
        this.close(this.dos);
        this.close(this.outLog);
        this.close(this.dis);
        this.close(this.inLog);
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void close(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

