/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.interfaces.Potentiometer;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.simulation.SimPotentiometer;
import edu.wpi.first.wpilibj.tables.ITable;

public class AnalogPotentiometer
implements Potentiometer,
LiveWindowSendable {
    private int module;
    private int channel;
    private SimPotentiometer impl;
    private ITable m_table;

    private void initPot(int slot, int channel, double scale, double offset) {
        this.module = slot;
        this.channel = channel;
        this.impl = new SimPotentiometer("simulator/analog/" + slot + "/" + channel);
    }

    public AnalogPotentiometer(int slot, int channel, double scale, double offset) {
        this.initPot(slot, channel, scale, offset);
    }

    public AnalogPotentiometer(int channel, double scale, double offset) {
        this.initPot(1, channel, scale, offset);
    }

    public AnalogPotentiometer(int channel, double scale) {
        this.initPot(1, channel, scale, 0.0);
    }

    public AnalogPotentiometer(int channel) {
        this.initPot(1, channel, 1.0, 0.0);
    }

    @Override
    public double get() {
        return this.impl.get();
    }

    @Override
    public double pidGet() {
        return this.impl.pidGet();
    }

    @Override
    public String getSmartDashboardType() {
        return "Analog Input";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

