/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.CounterBase;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.simulation.SimEncoder;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.util.BoundaryException;

public class Encoder
extends SensorBase
implements CounterBase,
PIDSource,
LiveWindowSendable {
    private int m_index;
    private double m_distancePerPulse;
    private CounterBase.EncodingType m_encodingType = CounterBase.EncodingType.k4X;
    private boolean m_allocatedA;
    private boolean m_allocatedB;
    private boolean m_allocatedI;
    private PIDSource.PIDSourceParameter m_pidSource;
    private SimEncoder impl;
    private ITable m_table;

    private void initEncoder(int aSlot, int aChannel, int bSlot, int bChannel, boolean reverseDirection) {
        LiveWindow.addSensor("Encoder", aSlot, aChannel, this);
        if (bSlot < aSlot || bSlot == aSlot && bChannel < aChannel) {
            int slot = bSlot;
            int channel = bChannel;
            bSlot = aSlot;
            bChannel = aChannel;
            aSlot = slot;
            aChannel = channel;
        }
        this.impl = new SimEncoder("simulator/dio/" + aSlot + "/" + aChannel + "/" + bSlot + "/" + bChannel);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        this.initEncoder(aSlot, aChannel, bSlot, bChannel, reverseDirection);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel) {
        this(aSlot, aChannel, bSlot, bChannel, false);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, boolean reverseDirection, CounterBase.EncodingType encodingType) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        if (encodingType == null) {
            throw new NullPointerException("Given encoding type was null");
        }
        this.m_encodingType = encodingType;
        this.initEncoder(aSlot, aChannel, bSlot, bChannel, reverseDirection);
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, int indexSlot, int indexChannel, boolean reverseDirection) {
        throw new UnsupportedOperationException("Simulation doesn't currently support indexed encoders.");
    }

    public Encoder(int aSlot, int aChannel, int bSlot, int bChannel, int indexSlot, int indexChannel) {
        throw new UnsupportedOperationException("Simulation doesn't currently support indexed encoders.");
    }

    public Encoder(int aChannel, int bChannel, boolean reverseDirection) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        this.initEncoder(1, aChannel, 1, bChannel, reverseDirection);
    }

    public Encoder(int aChannel, int bChannel) {
        this(aChannel, bChannel, false);
    }

    public Encoder(int aChannel, int bChannel, boolean reverseDirection, CounterBase.EncodingType encodingType) {
        this.m_allocatedA = true;
        this.m_allocatedB = true;
        this.m_allocatedI = false;
        if (encodingType == null) {
            throw new NullPointerException("Given encoding type was null");
        }
        this.m_encodingType = encodingType;
        this.initEncoder(1, aChannel, 1, bChannel, reverseDirection);
    }

    public Encoder(int aChannel, int bChannel, int indexChannel, boolean reverseDirection) {
        throw new UnsupportedOperationException("Simulation doesn't currently support indexed encoders.");
    }

    public Encoder(int aChannel, int bChannel, int indexChannel) {
        this(aChannel, bChannel, indexChannel, false);
    }

    @Override
    public void free() {
    }

    @Override
    public void start() {
        this.impl.start();
    }

    @Override
    public void stop() {
        this.impl.stop();
    }

    public int getRaw() {
        throw new UnsupportedOperationException("Simulation doesn't currently support raw values.");
    }

    @Override
    public int get() {
        throw new UnsupportedOperationException("Simulation doesn't support ticks.");
    }

    @Override
    public void reset() {
        this.impl.reset();
    }

    @Override
    public double getPeriod() {
        throw new UnsupportedOperationException("Simulation doesn't currently support deprecated methods.");
    }

    @Override
    public void setMaxPeriod(double maxPeriod) {
        throw new UnsupportedOperationException("Simulation doesn't currently support this method.");
    }

    @Override
    public boolean getStopped() {
        throw new UnsupportedOperationException("Simulation doesn't currently support this method.");
    }

    @Override
    public boolean getDirection() {
        throw new UnsupportedOperationException("Simulation doesn't currently support this method.");
    }

    public double getDistance() {
        return this.m_distancePerPulse * this.impl.getPosition();
    }

    public double getRate() {
        return this.m_distancePerPulse * this.impl.getVelocity();
    }

    public void setMinRate(double minRate) {
        throw new UnsupportedOperationException("Simulation doesn't currently support this method.");
    }

    public void setDistancePerPulse(double distancePerPulse) {
        System.err.println("WARNING: Encoder.setDistancePerPulse() assumes 360 pulses per revolution in simulation.");
        this.m_distancePerPulse = distancePerPulse;
    }

    public void setReverseDirection(boolean reverseDirection) {
        throw new UnsupportedOperationException("Simulation doesn't support reversing direction.");
    }

    public void setSamplesToAverage(int samplesToAverage) {
        throw new UnsupportedOperationException("Simulation doesn't support averaging samples.");
    }

    public int getSamplesToAverage() {
        throw new UnsupportedOperationException("Simulation doesn't support averaging samples.");
    }

    public void setPIDSourceParameter(PIDSource.PIDSourceParameter pidSource) {
        BoundaryException.assertWithinBounds(pidSource.value, 0.0, 1.0);
        this.m_pidSource = pidSource;
    }

    @Override
    public double pidGet() {
        switch (this.m_pidSource.value) {
            case 0: {
                return this.getDistance();
            }
            case 1: {
                return this.getRate();
            }
        }
        return 0.0;
    }

    @Override
    public String getSmartDashboardType() {
        switch (this.m_encodingType.value) {
            case 2: {
                return "Quadrature Encoder";
            }
        }
        return "Encoder";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Speed", this.getRate());
            this.m_table.putNumber("Distance", this.getDistance());
            this.m_table.putNumber("Distance per Tick", this.m_distancePerPulse);
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

