/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.simulation.SimGyro;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.util.BoundaryException;

public class Gyro
extends SensorBase
implements PIDSource,
LiveWindowSendable {
    double m_offset;
    int m_center;
    boolean m_channelAllocated = true;
    private PIDSource.PIDSourceParameter m_pidSource;
    private SimGyro impl;
    private ITable m_table;

    private void initGyro(int slot, int channel) {
        this.impl = new SimGyro("simulator/analog/" + slot + "/" + channel);
        this.reset();
        this.setPIDSourceParameter(PIDSource.PIDSourceParameter.kAngle);
        LiveWindow.addSensor("Gyro", slot, channel, this);
    }

    public Gyro(int slot, int channel) {
        this.initGyro(slot, channel);
    }

    public Gyro(int channel) {
        this.initGyro(1, channel);
    }

    public void reset() {
        this.impl.reset();
    }

    @Override
    public void free() {
    }

    public double getAngle() {
        return this.impl.getAngle();
    }

    public double getRate() {
        return this.impl.getVelocity();
    }

    public void setSensitivity(double voltsPerDegreePerSecond) {
        throw new UnsupportedOperationException("Simulation doesn't currently support setting the sensitivity.");
    }

    public void setPIDSourceParameter(PIDSource.PIDSourceParameter pidSource) {
        BoundaryException.assertWithinBounds(pidSource.value, 1.0, 2.0);
        this.m_pidSource = pidSource;
    }

    @Override
    public double pidGet() {
        switch (this.m_pidSource.value) {
            case 1: {
                return this.getRate();
            }
            case 2: {
                return this.getAngle();
            }
        }
        return 0.0;
    }

    @Override
    public String getSmartDashboardType() {
        return "Gyro";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getAngle());
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

