/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.simulation.JoystickProvider;
import edu.wpi.first.wpilibj.simulation.ds.DS;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;

public abstract class RobotBase {
    private static DS ds;
    public static final int ROBOT_TASK_PRIORITY = 101;
    public static final String ERRORS_TO_DRIVERSTATION_PROP = "first.driverstation.senderrors";

    protected RobotBase() {
        NetworkTable.setServerMode();
        NetworkTable.getTable((String)"");
        NetworkTable.getTable((String)"LiveWindow").getSubTable("~STATUS~").putBoolean("LW Enabled", false);
    }

    public void free() {
    }

    public boolean isSystemActive() {
        return true;
    }

    public static boolean isSimulation() {
        return true;
    }

    public static boolean isReal() {
        return false;
    }

    public boolean isDisabled() {
        return ds.getState() == DS.State.Disabled;
    }

    public boolean isEnabled() {
        return ds.getState() != DS.State.Disabled;
    }

    public boolean isAutonomous() {
        return ds.getState() == DS.State.Autonomous;
    }

    public boolean isTest() {
        return ds.getState() == DS.State.Test;
    }

    public boolean isOperatorControl() {
        return ds.getState() == DS.State.Teleop;
    }

    public boolean isNewDataAvailable() {
        return true;
    }

    public abstract void startCompetition();

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String propVal = System.getProperty(name);
        if (propVal == null) {
            return defaultValue;
        }
        if (propVal.equalsIgnoreCase("false")) {
            return false;
        }
        if (propVal.equalsIgnoreCase("true")) {
            return true;
        }
        throw new IllegalStateException(propVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        RobotBase robot;
        boolean errorOnExit = false;
        ds = new DS(JoystickProvider.getInstance());
        String robotName = "";
        Enumeration<URL> resources = null;
        try {
            resources = RobotBase.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (resources != null && resources.hasMoreElements()) {
            try {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                robotName = manifest.getMainAttributes().getValue("Robot-Class");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            robot = (RobotBase)Class.forName(robotName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            System.err.println("WARNING: Robots don't quit!");
            System.err.println("ERROR: Could not instantiate robot " + robotName + "!");
            return;
        }
        try {
            robot.startCompetition();
        }
        catch (Throwable t) {
            t.printStackTrace();
            errorOnExit = true;
        }
        finally {
            System.err.println("WARNING: Robots don't quit!");
            if (errorOnExit) {
                System.err.println("---> The startCompetition() method (or methods called by it) should have handled the exception above.");
            } else {
                System.err.println("---> Unexpected return from startCompetition() method.");
            }
        }
    }
}

