/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.Talon;

public class RobotDrive
implements MotorSafety {
    protected MotorSafetyHelper m_safetyHelper;
    public static final double kDefaultExpirationTime = 0.1;
    public static final double kDefaultSensitivity = 0.5;
    public static final double kDefaultMaxOutput = 1.0;
    protected static final int kMaxNumberOfMotors = 4;
    protected final int[] m_invertedMotors = new int[4];
    protected double m_sensitivity;
    protected double m_maxOutput;
    protected SpeedController m_frontLeftMotor;
    protected SpeedController m_frontRightMotor;
    protected SpeedController m_rearLeftMotor;
    protected SpeedController m_rearRightMotor;
    protected boolean m_allocatedSpeedControllers;
    protected boolean m_isCANInitialized = true;
    protected static boolean kArcadeRatioCurve_Reported = false;
    protected static boolean kTank_Reported = false;
    protected static boolean kArcadeStandard_Reported = false;
    protected static boolean kMecanumCartesian_Reported = false;
    protected static boolean kMecanumPolar_Reported = false;

    public RobotDrive(int leftMotorChannel, int rightMotorChannel) {
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        this.m_frontLeftMotor = null;
        this.m_rearLeftMotor = new Talon(leftMotorChannel);
        this.m_frontRightMotor = null;
        this.m_rearRightMotor = new Talon(rightMotorChannel);
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.m_allocatedSpeedControllers = true;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public RobotDrive(int frontLeftMotor, int rearLeftMotor, int frontRightMotor, int rearRightMotor) {
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        this.m_rearLeftMotor = new Talon(rearLeftMotor);
        this.m_rearRightMotor = new Talon(rearRightMotor);
        this.m_frontLeftMotor = new Talon(frontLeftMotor);
        this.m_frontRightMotor = new Talon(frontRightMotor);
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.m_allocatedSpeedControllers = true;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public RobotDrive(SpeedController leftMotor, SpeedController rightMotor) {
        if (leftMotor == null || rightMotor == null) {
            this.m_rearRightMotor = null;
            this.m_rearLeftMotor = null;
            throw new NullPointerException("Null motor provided");
        }
        this.m_frontLeftMotor = null;
        this.m_rearLeftMotor = leftMotor;
        this.m_frontRightMotor = null;
        this.m_rearRightMotor = rightMotor;
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.m_allocatedSpeedControllers = false;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public RobotDrive(SpeedController frontLeftMotor, SpeedController rearLeftMotor, SpeedController frontRightMotor, SpeedController rearRightMotor) {
        if (frontLeftMotor == null || rearLeftMotor == null || frontRightMotor == null || rearRightMotor == null) {
            this.m_rearRightMotor = null;
            this.m_frontRightMotor = null;
            this.m_rearLeftMotor = null;
            this.m_frontLeftMotor = null;
            throw new NullPointerException("Null motor provided");
        }
        this.m_frontLeftMotor = frontLeftMotor;
        this.m_rearLeftMotor = rearLeftMotor;
        this.m_frontRightMotor = frontRightMotor;
        this.m_rearRightMotor = rearRightMotor;
        this.m_sensitivity = 0.5;
        this.m_maxOutput = 1.0;
        for (int i = 0; i < 4; ++i) {
            this.m_invertedMotors[i] = 1;
        }
        this.m_allocatedSpeedControllers = false;
        this.setupMotorSafety();
        this.drive(0.0, 0.0);
    }

    public void drive(double outputMagnitude, double curve) {
        double rightOutput;
        double leftOutput;
        if (!kArcadeRatioCurve_Reported) {
            kArcadeRatioCurve_Reported = true;
        }
        if (curve < 0.0) {
            double value = Math.log(-curve);
            double ratio = (value - this.m_sensitivity) / (value + this.m_sensitivity);
            if (ratio == 0.0) {
                ratio = 1.0E-10;
            }
            leftOutput = outputMagnitude / ratio;
            rightOutput = outputMagnitude;
        } else if (curve > 0.0) {
            double value = Math.log(curve);
            double ratio = (value - this.m_sensitivity) / (value + this.m_sensitivity);
            if (ratio == 0.0) {
                ratio = 1.0E-10;
            }
            leftOutput = outputMagnitude;
            rightOutput = outputMagnitude / ratio;
        } else {
            leftOutput = outputMagnitude;
            rightOutput = outputMagnitude;
        }
        this.setLeftRightMotorOutputs(leftOutput, rightOutput);
    }

    public void tankDrive(GenericHID leftStick, GenericHID rightStick) {
        if (leftStick == null || rightStick == null) {
            throw new NullPointerException("Null HID provided");
        }
        this.tankDrive(leftStick.getY(), rightStick.getY(), true);
    }

    public void tankDrive(GenericHID leftStick, GenericHID rightStick, boolean squaredInputs) {
        if (leftStick == null || rightStick == null) {
            throw new NullPointerException("Null HID provided");
        }
        this.tankDrive(leftStick.getY(), rightStick.getY(), squaredInputs);
    }

    public void tankDrive(GenericHID leftStick, int leftAxis, GenericHID rightStick, int rightAxis) {
        if (leftStick == null || rightStick == null) {
            throw new NullPointerException("Null HID provided");
        }
        this.tankDrive(leftStick.getRawAxis(leftAxis), rightStick.getRawAxis(rightAxis), true);
    }

    public void tankDrive(GenericHID leftStick, int leftAxis, GenericHID rightStick, int rightAxis, boolean squaredInputs) {
        if (leftStick == null || rightStick == null) {
            throw new NullPointerException("Null HID provided");
        }
        this.tankDrive(leftStick.getRawAxis(leftAxis), rightStick.getRawAxis(rightAxis), squaredInputs);
    }

    public void tankDrive(double leftValue, double rightValue, boolean squaredInputs) {
        if (!kTank_Reported) {
            kTank_Reported = true;
        }
        leftValue = RobotDrive.limit(leftValue);
        rightValue = RobotDrive.limit(rightValue);
        if (squaredInputs) {
            leftValue = leftValue >= 0.0 ? (leftValue *= leftValue) : -(leftValue * leftValue);
            rightValue = rightValue >= 0.0 ? (rightValue *= rightValue) : -(rightValue * rightValue);
        }
        this.setLeftRightMotorOutputs(leftValue, rightValue);
    }

    public void tankDrive(double leftValue, double rightValue) {
        this.tankDrive(leftValue, rightValue, true);
    }

    public void arcadeDrive(GenericHID stick, boolean squaredInputs) {
        this.arcadeDrive(stick.getY(), stick.getX(), squaredInputs);
    }

    public void arcadeDrive(GenericHID stick) {
        this.arcadeDrive(stick, true);
    }

    public void arcadeDrive(GenericHID moveStick, int moveAxis, GenericHID rotateStick, int rotateAxis, boolean squaredInputs) {
        double moveValue = moveStick.getRawAxis(moveAxis);
        double rotateValue = rotateStick.getRawAxis(rotateAxis);
        this.arcadeDrive(moveValue, rotateValue, squaredInputs);
    }

    public void arcadeDrive(GenericHID moveStick, int moveAxis, GenericHID rotateStick, int rotateAxis) {
        this.arcadeDrive(moveStick, moveAxis, rotateStick, rotateAxis, true);
    }

    public void arcadeDrive(double moveValue, double rotateValue, boolean squaredInputs) {
        double rightMotorSpeed;
        double leftMotorSpeed;
        if (!kArcadeStandard_Reported) {
            kArcadeStandard_Reported = true;
        }
        moveValue = RobotDrive.limit(moveValue);
        rotateValue = RobotDrive.limit(rotateValue);
        if (squaredInputs) {
            moveValue = moveValue >= 0.0 ? (moveValue *= moveValue) : -(moveValue * moveValue);
            rotateValue = rotateValue >= 0.0 ? (rotateValue *= rotateValue) : -(rotateValue * rotateValue);
        }
        if (moveValue > 0.0) {
            if (rotateValue > 0.0) {
                leftMotorSpeed = moveValue - rotateValue;
                rightMotorSpeed = Math.max(moveValue, rotateValue);
            } else {
                leftMotorSpeed = Math.max(moveValue, -rotateValue);
                rightMotorSpeed = moveValue + rotateValue;
            }
        } else if (rotateValue > 0.0) {
            leftMotorSpeed = -Math.max(-moveValue, rotateValue);
            rightMotorSpeed = moveValue + rotateValue;
        } else {
            leftMotorSpeed = moveValue - rotateValue;
            rightMotorSpeed = -Math.max(-moveValue, -rotateValue);
        }
        this.setLeftRightMotorOutputs(leftMotorSpeed, rightMotorSpeed);
    }

    public void arcadeDrive(double moveValue, double rotateValue) {
        this.arcadeDrive(moveValue, rotateValue, true);
    }

    public void mecanumDrive_Cartesian(double x, double y, double rotation, double gyroAngle) {
        if (!kMecanumCartesian_Reported) {
            kMecanumCartesian_Reported = true;
        }
        double xIn = x;
        double yIn = y;
        yIn = -yIn;
        double[] rotated = RobotDrive.rotateVector(xIn, yIn, gyroAngle);
        xIn = rotated[0];
        yIn = rotated[1];
        double[] wheelSpeeds = new double[]{xIn + yIn + rotation, -xIn + yIn - rotation, -xIn + yIn + rotation, xIn + yIn - rotation};
        RobotDrive.normalize(wheelSpeeds);
        byte syncGroup = -128;
        this.m_frontLeftMotor.set(wheelSpeeds[0] * (double)this.m_invertedMotors[0] * this.m_maxOutput, syncGroup);
        this.m_frontRightMotor.set(wheelSpeeds[1] * (double)this.m_invertedMotors[1] * this.m_maxOutput, syncGroup);
        this.m_rearLeftMotor.set(wheelSpeeds[2] * (double)this.m_invertedMotors[2] * this.m_maxOutput, syncGroup);
        this.m_rearRightMotor.set(wheelSpeeds[3] * (double)this.m_invertedMotors[3] * this.m_maxOutput, syncGroup);
        if (this.m_safetyHelper != null) {
            this.m_safetyHelper.feed();
        }
    }

    public void mecanumDrive_Polar(double magnitude, double direction, double rotation) {
        if (!kMecanumPolar_Reported) {
            kMecanumPolar_Reported = true;
        }
        magnitude = RobotDrive.limit(magnitude) * Math.sqrt(2.0);
        double dirInRad = (direction + 45.0) * 3.14159 / 180.0;
        double cosD = Math.cos(dirInRad);
        double sinD = Math.sin(dirInRad);
        double[] wheelSpeeds = new double[]{sinD * magnitude + rotation, cosD * magnitude - rotation, cosD * magnitude + rotation, sinD * magnitude - rotation};
        RobotDrive.normalize(wheelSpeeds);
        byte syncGroup = -128;
        this.m_frontLeftMotor.set(wheelSpeeds[0] * (double)this.m_invertedMotors[0] * this.m_maxOutput, syncGroup);
        this.m_frontRightMotor.set(wheelSpeeds[1] * (double)this.m_invertedMotors[1] * this.m_maxOutput, syncGroup);
        this.m_rearLeftMotor.set(wheelSpeeds[2] * (double)this.m_invertedMotors[2] * this.m_maxOutput, syncGroup);
        this.m_rearRightMotor.set(wheelSpeeds[3] * (double)this.m_invertedMotors[3] * this.m_maxOutput, syncGroup);
        if (this.m_safetyHelper != null) {
            this.m_safetyHelper.feed();
        }
    }

    void holonomicDrive(float magnitude, float direction, float rotation) {
        this.mecanumDrive_Polar(magnitude, direction, rotation);
    }

    public void setLeftRightMotorOutputs(double leftOutput, double rightOutput) {
        if (this.m_rearLeftMotor == null || this.m_rearRightMotor == null) {
            throw new NullPointerException("Null motor provided");
        }
        byte syncGroup = -128;
        if (this.m_frontLeftMotor != null) {
            this.m_frontLeftMotor.set(RobotDrive.limit(leftOutput) * (double)this.m_invertedMotors[0] * this.m_maxOutput, syncGroup);
        }
        this.m_rearLeftMotor.set(RobotDrive.limit(leftOutput) * (double)this.m_invertedMotors[2] * this.m_maxOutput, syncGroup);
        if (this.m_frontRightMotor != null) {
            this.m_frontRightMotor.set(-RobotDrive.limit(rightOutput) * (double)this.m_invertedMotors[1] * this.m_maxOutput, syncGroup);
        }
        this.m_rearRightMotor.set(-RobotDrive.limit(rightOutput) * (double)this.m_invertedMotors[3] * this.m_maxOutput, syncGroup);
        if (this.m_safetyHelper != null) {
            this.m_safetyHelper.feed();
        }
    }

    protected static double limit(double num) {
        if (num > 1.0) {
            return 1.0;
        }
        if (num < -1.0) {
            return -1.0;
        }
        return num;
    }

    protected static void normalize(double[] wheelSpeeds) {
        int i;
        double maxMagnitude = Math.abs(wheelSpeeds[0]);
        for (i = 1; i < 4; ++i) {
            double temp = Math.abs(wheelSpeeds[i]);
            if (!(maxMagnitude < temp)) continue;
            maxMagnitude = temp;
        }
        if (maxMagnitude > 1.0) {
            for (i = 0; i < 4; ++i) {
                wheelSpeeds[i] = wheelSpeeds[i] / maxMagnitude;
            }
        }
    }

    protected static double[] rotateVector(double x, double y, double angle) {
        double cosA = Math.cos(angle * 0.017453277777777776);
        double sinA = Math.sin(angle * 0.017453277777777776);
        double[] out = new double[]{x * cosA - y * sinA, x * sinA + y * cosA};
        return out;
    }

    public void setInvertedMotor(MotorType motor, boolean isInverted) {
        this.m_invertedMotors[motor.value] = isInverted ? -1 : 1;
    }

    public void setSensitivity(double sensitivity) {
        this.m_sensitivity = sensitivity;
    }

    public void setMaxOutput(double maxOutput) {
        this.m_maxOutput = maxOutput;
    }

    public void free() {
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public String getDescription() {
        return "Robot Drive";
    }

    @Override
    public void stopMotor() {
        if (this.m_frontLeftMotor != null) {
            this.m_frontLeftMotor.set(0.0);
        }
        if (this.m_frontRightMotor != null) {
            this.m_frontRightMotor.set(0.0);
        }
        if (this.m_rearLeftMotor != null) {
            this.m_rearLeftMotor.set(0.0);
        }
        if (this.m_rearRightMotor != null) {
            this.m_rearRightMotor.set(0.0);
        }
    }

    private void setupMotorSafety() {
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_safetyHelper.setExpiration(0.1);
        this.m_safetyHelper.setSafetyEnabled(true);
    }

    protected int getNumMotors() {
        int motors = 0;
        if (this.m_frontLeftMotor != null) {
            ++motors;
        }
        if (this.m_frontRightMotor != null) {
            ++motors;
        }
        if (this.m_rearLeftMotor != null) {
            ++motors;
        }
        if (this.m_rearRightMotor != null) {
            ++motors;
        }
        return motors;
    }

    public static class MotorType {
        public final int value;
        static final int kFrontLeft_val = 0;
        static final int kFrontRight_val = 1;
        static final int kRearLeft_val = 2;
        static final int kRearRight_val = 3;
        public static final MotorType kFrontLeft = new MotorType(0);
        public static final MotorType kFrontRight = new MotorType(1);
        public static final MotorType kRearLeft = new MotorType(2);
        public static final MotorType kRearRight = new MotorType(3);

        private MotorType(int value) {
            this.value = value;
        }
    }
}

