/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

public abstract class SensorBase {
    public static final int kSystemClockTicksPerMicrosecond = 40;
    public static final int kDigitalChannels = 14;
    public static final int kDigitalModules = 2;
    public static final int kAnalogChannels = 8;
    public static final int kAnalogModules = 2;
    public static final int kSolenoidChannels = 8;
    public static final int kSolenoidModules = 2;
    public static final int kPwmChannels = 10;
    public static final int kRelayChannels = 8;
    private static int m_defaultAnalogModule = 1;
    private static int m_defaultDigitalModule = 1;
    private static int m_defaultSolenoidModule = 1;

    public static void setDefaultDigitalModule(int moduleNumber) {
        SensorBase.checkDigitalModule(moduleNumber);
        m_defaultDigitalModule = moduleNumber;
    }

    public static void setDefaultAnalogModule(int moduleNumber) {
        SensorBase.checkAnalogModule(moduleNumber);
        m_defaultAnalogModule = moduleNumber;
    }

    public static void setDefaultSolenoidModule(int moduleNumber) {
        SensorBase.checkSolenoidModule(moduleNumber);
        m_defaultSolenoidModule = moduleNumber;
    }

    protected static void checkDigitalModule(int moduleNumber) {
        if (moduleNumber == 1 || moduleNumber == 2) {
            System.err.println("Digital module " + moduleNumber + " is not present.");
        }
    }

    protected static void checkRelayModule(int moduleNumber) {
        SensorBase.checkDigitalModule(moduleNumber);
    }

    protected static void checkPWMModule(int moduleNumber) {
        SensorBase.checkDigitalModule(moduleNumber);
    }

    protected static void checkAnalogModule(int moduleNumber) {
        if (moduleNumber == 1 || moduleNumber == 2) {
            System.err.println("Analog module " + moduleNumber + " is not present.");
        }
    }

    protected static void checkSolenoidModule(int moduleNumber) {
        if (moduleNumber == 1 || moduleNumber == 2) {
            System.err.println("Solenoid module " + moduleNumber + " is not present.");
        }
    }

    protected static void checkDigitalChannel(int channel) {
        if (channel <= 0 || channel > 14) {
            System.err.println("Requested digital channel number is out of range.");
        }
    }

    protected static void checkRelayChannel(int channel) {
        if (channel <= 0 || channel > 8) {
            System.err.println("Requested relay channel number is out of range.");
            throw new IndexOutOfBoundsException("Requested relay channel number is out of range.");
        }
    }

    protected static void checkPWMChannel(int channel) {
        if (channel <= 0 || channel > 10) {
            System.err.println("Requested PWM channel number is out of range.");
            throw new IndexOutOfBoundsException("Requested PWM channel number is out of range.");
        }
    }

    protected static void checkAnalogChannel(int channel) {
        if (channel <= 0 || channel > 8) {
            System.err.println("Requested analog channel number is out of range.");
        }
    }

    protected static void checkSolenoidChannel(int channel) {
        if (channel <= 0 || channel > 8) {
            System.err.println("Requested solenoid channel number is out of range.");
        }
    }

    public static int getDefaultAnalogModule() {
        return m_defaultAnalogModule;
    }

    public static int getDefaultDigitalModule() {
        return m_defaultDigitalModule;
    }

    public static int getDefaultSolenoidModule() {
        return m_defaultSolenoidModule;
    }

    public void free() {
    }
}

