/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

public class Timer {
    private long m_startTime;
    private double m_accumulatedTime;
    private boolean m_running;

    public static void delay(double seconds) {
        try {
            Thread.sleep((long)(seconds * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static long getUsClock() {
        return System.nanoTime() / 1000L;
    }

    static long getMsClock() {
        return System.currentTimeMillis();
    }

    public static double getFPGATimestamp() {
        return (double)System.currentTimeMillis() / 1000.0;
    }

    public Timer() {
        this.reset();
    }

    public synchronized double get() {
        if (this.m_running) {
            return ((double)(Timer.getMsClock() - this.m_startTime) + this.m_accumulatedTime) / 1000.0;
        }
        return this.m_accumulatedTime;
    }

    public synchronized void reset() {
        this.m_accumulatedTime = 0.0;
        this.m_startTime = Timer.getMsClock();
    }

    public synchronized void start() {
        this.m_startTime = Timer.getMsClock();
        this.m_running = true;
    }

    public synchronized void stop() {
        double temp;
        this.m_accumulatedTime = temp = this.get();
        this.m_running = false;
    }
}

