/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.simulation.SimSpeedController;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class Victor
implements SpeedController,
PIDOutput,
MotorSafety,
LiveWindowSendable {
    private int module;
    private int channel;
    private SimSpeedController impl;
    private MotorSafetyHelper m_safetyHelper;
    private ITable m_table;
    private ITableListener m_table_listener;

    private void initTalon(int slot, int channel) {
        this.module = slot;
        this.channel = channel;
        this.impl = new SimSpeedController("simulator/pwm/" + slot + "/" + channel);
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_safetyHelper.setExpiration(0.0);
        this.m_safetyHelper.setSafetyEnabled(false);
    }

    public Victor(int channel) {
        this.initTalon(1, channel);
    }

    public Victor(int slot, int channel) {
        this.initTalon(slot, channel);
    }

    @Override
    public void set(double speed, byte syncGroup) {
        this.impl.set(speed, syncGroup);
    }

    @Override
    public void set(double speed) {
        this.impl.set(speed);
    }

    @Override
    public double get() {
        return this.impl.get();
    }

    @Override
    public void disable() {
        this.impl.set(0.0);
    }

    @Override
    public void pidWrite(double output) {
        this.impl.pidWrite(output);
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public void stopMotor() {
        this.disable();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public String getDescription() {
        return "PWM " + this.channel + " on module " + this.module;
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public String getSmartDashboardType() {
        return "Speed Controller";
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    @Override
    public void startLiveWindowMode() {
        this.set(0.0);
        this.m_table_listener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                Victor.this.set((Double)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_table_listener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.set(0.0);
        this.m_table.removeTableListener(this.m_table_listener);
    }
}

