/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.livewindow;

import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.livewindow.LiveWindowComponent;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LiveWindow {
    private static Vector sensors = new Vector();
    private static Hashtable components = new Hashtable();
    private static ITable livewindowTable = NetworkTable.getTable((String)"LiveWindow");
    private static ITable statusTable = livewindowTable.getSubTable("~STATUS~");
    private static boolean liveWindowEnabled = false;
    private static boolean firstTime = true;

    private static void initializeLiveWindowComponents() {
        System.out.println("Initializing the components first time");
        Enumeration e = components.keys();
        while (e.hasMoreElements()) {
            LiveWindowSendable component = (LiveWindowSendable)e.nextElement();
            LiveWindowComponent c = (LiveWindowComponent)components.get(component);
            String subsystem = c.getSubsystem();
            String name = c.getName();
            System.out.println("Initializing table for '" + subsystem + "' '" + name + "'");
            livewindowTable.getSubTable(subsystem).putString("~TYPE~", "LW Subsystem");
            ITable table = livewindowTable.getSubTable(subsystem).getSubTable(name);
            table.putString("~TYPE~", component.getSmartDashboardType());
            table.putString("Name", name);
            table.putString("Subsystem", subsystem);
            component.initTable(table);
            if (!c.isSensor()) continue;
            sensors.addElement(component);
        }
    }

    public static void setEnabled(boolean enabled) {
        if (liveWindowEnabled != enabled) {
            if (enabled) {
                System.out.println("Starting live window mode.");
                if (firstTime) {
                    LiveWindow.initializeLiveWindowComponents();
                    firstTime = false;
                }
                Scheduler.getInstance().disable();
                Scheduler.getInstance().removeAll();
                Enumeration e = components.keys();
                while (e.hasMoreElements()) {
                    LiveWindowSendable component = (LiveWindowSendable)e.nextElement();
                    component.startLiveWindowMode();
                }
            } else {
                System.out.println("stopping live window mode.");
                Enumeration e = components.keys();
                while (e.hasMoreElements()) {
                    LiveWindowSendable component = (LiveWindowSendable)e.nextElement();
                    component.stopLiveWindowMode();
                }
                Scheduler.getInstance().enable();
            }
            liveWindowEnabled = enabled;
            statusTable.putBoolean("LW Enabled", enabled);
        }
    }

    public static void run() {
        LiveWindow.updateValues();
    }

    public static void addSensor(String subsystem, String name, LiveWindowSendable component) {
        components.put(component, new LiveWindowComponent(subsystem, name, true));
    }

    public static void addActuator(String subsystem, String name, LiveWindowSendable component) {
        components.put(component, new LiveWindowComponent(subsystem, name, false));
    }

    private static void updateValues() {
        for (int i = 0; i < sensors.size(); ++i) {
            LiveWindowSendable lws = (LiveWindowSendable)sensors.elementAt(i);
            lws.updateTable();
        }
    }

    public static void addSensor(String moduleType, int moduleNumber, int channel, LiveWindowSendable component) {
        LiveWindow.addSensor("Ungrouped", moduleType + "[" + moduleNumber + "," + channel + "]", component);
        if (sensors.contains(component)) {
            sensors.removeElement(component);
        }
        sensors.addElement(component);
    }

    public static void addActuator(String moduleType, int moduleNumber, int channel, LiveWindowSendable component) {
        LiveWindow.addActuator("Ungrouped", moduleType + "[" + moduleNumber + "," + channel + "]", component);
    }
}

