/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.simulation;

import edu.wpi.first.wpilibj.simulation.ISimJoystick;
import edu.wpi.first.wpilibj.simulation.SimJoystick;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public class JoystickProvider {
    List<ISimJoystick> joysticks;
    public static final JoystickProvider instance = new JoystickProvider();

    private JoystickProvider() {
        this.setJoysticks(this.getJoysticks());
    }

    public static JoystickProvider getInstance() {
        return instance;
    }

    public List<ISimJoystick> getJoysticks() {
        ArrayList<ISimJoystick> foundControllers = new ArrayList<ISimJoystick>();
        Controller[] controllers = ControllerEnvironment.getDefaultEnvironment().getControllers();
        for (int i = 0; i < controllers.length; ++i) {
            Controller controller = controllers[i];
            if (controller.getType() != Controller.Type.STICK && controller.getType() != Controller.Type.GAMEPAD && controller.getType() != Controller.Type.WHEEL && controller.getType() != Controller.Type.FINGERSTICK) continue;
            foundControllers.add(new SimJoystick(controller));
        }
        return foundControllers;
    }

    public void setJoysticks(List<ISimJoystick> joysticks) {
        this.joysticks = joysticks;
    }

    public double getAxis(int port, int axis) {
        return this.joysticks.get(port - 1).getAxis(axis - 1);
    }

    public boolean getButton(int port, int button) {
        return this.joysticks.get(port - 1).getButton(button - 1);
    }
}

