/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.simulation;

import edu.wpi.first.wpilibj.simulation.MainNode;
import org.ros.message.MessageListener;
import org.ros.node.topic.Publisher;
import org.ros.node.topic.Subscriber;
import std_msgs.Float64;
import std_msgs.String;

public class SimGyro {
    private double position;
    private double velocity;
    private Publisher<String> command_pub;
    private Subscriber<Float64> position_sub;
    private Subscriber<Float64> velocity_sub;

    public SimGyro(java.lang.String topic) {
        this.command_pub = MainNode.getInstance().getConnectedNode().newPublisher(topic + "/control", "std_msgs/String");
        this.command_pub.setLatchMode(true);
        this.position_sub = MainNode.getInstance().getConnectedNode().newSubscriber(topic + "/position", "std_msgs/Float64");
        this.position_sub.addMessageListener((MessageListener)new MessageListener<Float64>(){

            public void onNewMessage(Float64 value) {
                SimGyro.this.position = value.getData();
            }
        });
        this.velocity_sub = MainNode.getInstance().getConnectedNode().newSubscriber(topic + "/velocity", "std_msgs/Float64");
        this.velocity_sub.addMessageListener((MessageListener)new MessageListener<Float64>(){

            public void onNewMessage(Float64 value) {
                SimGyro.this.velocity = value.getData();
            }
        });
    }

    public void reset() {
        this.sendCommand("reset");
    }

    private void sendCommand(java.lang.String cmd) {
        String msg = (String)this.command_pub.newMessage();
        msg.setData(cmd);
        this.command_pub.publish((Object)msg);
    }

    public double getAngle() {
        return this.position;
    }

    public double getVelocity() {
        return this.velocity;
    }
}

