/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.simulation;

import edu.wpi.first.wpilibj.simulation.ISimJoystick;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;

public class SimJoystick
implements ISimJoystick {
    private Controller controller;
    private List<Component> axis;
    private List<Component> buttons;

    public SimJoystick(Controller controller) {
        this.controller = controller;
        this.axis = new ArrayList<Component>();
        this.buttons = new ArrayList<Component>();
        for (Component c : controller.getComponents()) {
            if (c.getIdentifier() instanceof Component.Identifier.Axis) {
                this.axis.add(c);
                continue;
            }
            if (!(c.getIdentifier() instanceof Component.Identifier.Button)) continue;
            this.buttons.add(c);
        }
    }

    @Override
    public double getAxis(int a) {
        this.controller.poll();
        return this.axis.get(a).getPollData();
    }

    @Override
    public boolean getButton(int b) {
        this.controller.poll();
        return (double)this.buttons.get(b).getPollData() > 0.5;
    }

    @Override
    public String getName() {
        return this.controller.getName();
    }

    public String toString() {
        return this.getName();
    }
}

