/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.simulation.ds;

import edu.wpi.first.wpilibj.simulation.FakeJoystick;
import edu.wpi.first.wpilibj.simulation.ISimJoystick;
import edu.wpi.first.wpilibj.simulation.JoystickProvider;
import edu.wpi.first.wpilibj.simulation.ds.EnableAction;
import edu.wpi.first.wpilibj.simulation.ds.JoystickList;
import edu.wpi.first.wpilibj.simulation.ds.ModeAction;
import edu.wpi.first.wpilibj.simulation.ds.RefreshAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DS {
    private JoystickProvider joystickProvider;
    private JoystickList joysticks;
    private JFrame mainframe;
    private JPanel modePanel;
    private ActionListener modeListener;
    private ButtonGroup modes;
    private JButton enable;
    private JButton refresh;
    private boolean enabled = false;
    private State state = State.Teleop;

    public DS(JoystickProvider joystickProvider) {
        this.joystickProvider = joystickProvider;
        this.mainframe = new JFrame();
        this.mainframe.setTitle("FRC Simulation DriverStation");
        this.mainframe.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.makeModeButtons(constraints);
        this.mainframe.pack();
        constraints.gridy = 1;
        this.makeEnableButton(constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        this.makeJoystickUI(constraints);
        this.mainframe.pack();
        constraints.gridy = 1;
        this.makeRefreshButton(constraints);
        this.mainframe.pack();
        this.mainframe.setVisible(true);
    }

    private void makeModeButtons(GridBagConstraints constraints) {
        this.modePanel = new JPanel();
        this.modePanel.setLayout(new BoxLayout(this.modePanel, 3));
        this.modeListener = new ModeAction(this);
        JRadioButton teleop = new JRadioButton("Teleop");
        teleop.setActionCommand(State.Teleop.toString());
        teleop.addActionListener(this.modeListener);
        JRadioButton auto = new JRadioButton("Autonomous");
        auto.setActionCommand(State.Autonomous.toString());
        auto.addActionListener(this.modeListener);
        JRadioButton test = new JRadioButton("Test");
        test.setActionCommand(State.Test.toString());
        test.addActionListener(this.modeListener);
        teleop.setSelected(true);
        this.modes = new ButtonGroup();
        this.modes.add(teleop);
        this.modes.add(auto);
        this.modes.add(test);
        this.modePanel.add(teleop);
        this.modePanel.add(auto);
        this.modePanel.add(test);
        this.mainframe.add((Component)this.modePanel, constraints);
    }

    private void makeEnableButton(GridBagConstraints constraints) {
        this.enable = new JButton("Enable");
        this.enable.addActionListener(new EnableAction(this));
        this.enable.setPreferredSize(new Dimension(this.modePanel.getSize().width, 50));
        this.mainframe.add((Component)this.enable, constraints);
    }

    private void makeJoystickUI(GridBagConstraints constraints) {
        this.joysticks = new JoystickList(this.joystickProvider);
        this.mainframe.add((Component)this.joysticks, constraints);
        this.scanForJoysticks();
    }

    public void scanForJoysticks() {
        this.joysticks.removeAll();
        List<ISimJoystick> sticks = this.joystickProvider.getJoysticks();
        while (sticks.size() < 4) {
            sticks.add(new FakeJoystick());
        }
        this.joysticks.setListData(sticks);
    }

    private void makeRefreshButton(GridBagConstraints constraints) {
        this.refresh = new JButton("Refresh Joysticks");
        this.refresh.addActionListener(new RefreshAction(this));
        this.refresh.setPreferredSize(new Dimension(this.joysticks.getSize().width, 50));
        this.mainframe.add((Component)this.refresh, constraints);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enable.setText(enabled ? "Disable" : "Enable");
    }

    public State getState() {
        return this.enabled ? this.state : State.Disabled;
    }

    public void setState(State state) {
        this.setEnabled(false);
        this.state = state;
    }

    public void toggleEnable() {
        this.setEnabled(!this.enabled);
    }

    public static enum State {
        Disabled,
        Teleop,
        Autonomous,
        Test;

    }
}

