/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.simulation.ds;

import edu.wpi.first.wpilibj.simulation.ISimJoystick;
import edu.wpi.first.wpilibj.simulation.JoystickProvider;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.TransferHandler;

public class JoystickList
extends JList<ISimJoystick> {
    private JoystickProvider joystickProvider;
    List<ISimJoystick> joysticks;

    public JoystickList(JoystickProvider joystickProvider) {
        this.joystickProvider = joystickProvider;
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        this.setTransferHandler(new DropHandler(this));
        new DragListener(this);
    }

    public void moveElement(int index, int dropTargetIndex) {
        ISimJoystick move = this.joysticks.get(index);
        this.joysticks.add(dropTargetIndex, move);
        this.joysticks.remove(index < dropTargetIndex ? index : index + 1);
        this.setListData(this.joysticks);
    }

    @Override
    public void setListData(List<ISimJoystick> sticks) {
        this.joysticks = sticks;
        this.setListData(sticks.toArray(new ISimJoystick[0]));
        this.joystickProvider.setJoysticks(sticks);
    }

    class DropHandler
    extends TransferHandler {
        JoystickList list;

        public DropHandler(JoystickList list) {
            this.list = list;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            return dl.getIndex() != -1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            String indexString;
            if (!this.canImport(support)) {
                return false;
            }
            Transferable transferable = support.getTransferable();
            try {
                indexString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception e) {
                return false;
            }
            int index = Integer.parseInt(indexString);
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            int dropTargetIndex = dl.getIndex();
            this.list.moveElement(index, dropTargetIndex);
            return true;
        }
    }

    class DragListener
    implements DragSourceListener,
    DragGestureListener {
        JoystickList list;
        DragSource ds = new DragSource();

        public DragListener(JoystickList list) {
            this.list = list;
            this.ds.createDefaultDragGestureRecognizer(list, 2, this);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            StringSelection transferable = new StringSelection(Integer.toString(this.list.getSelectedIndex()));
            this.ds.startDrag(dge, DragSource.DefaultCopyDrop, transferable, this);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }
}

