/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.smartdashboard;

import edu.wpi.first.wpilibj.NamedSendable;
import edu.wpi.first.wpilibj.Sendable;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class SmartDashboard {
    private static final NetworkTable table = NetworkTable.getTable((String)"SmartDashboard");
    private static final Hashtable tablesToData = new Hashtable();

    public static void putData(String key, Sendable data) {
        ITable dataTable = table.getSubTable(key);
        dataTable.putString("~TYPE~", data.getSmartDashboardType());
        data.initTable(dataTable);
        tablesToData.put(data, key);
    }

    public static void putData(NamedSendable value) {
        SmartDashboard.putData(value.getName(), value);
    }

    public static void putBoolean(String key, boolean value) {
        table.putBoolean(key, value);
    }

    public static boolean getBoolean(String key) throws TableKeyNotDefinedException {
        return table.getBoolean(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        return table.getBoolean(key, defaultValue);
    }

    public static void putNumber(String key, double value) {
        table.putNumber(key, value);
    }

    public static double getNumber(String key) throws TableKeyNotDefinedException {
        return table.getNumber(key);
    }

    public static double getNumber(String key, double defaultValue) {
        return table.getNumber(key, defaultValue);
    }

    public static void putString(String key, String value) {
        table.putString(key, value);
    }

    public static String getString(String key) throws TableKeyNotDefinedException {
        return table.getString(key);
    }

    public static String getString(String key, String defaultValue) {
        return table.getString(key, defaultValue);
    }

    public static void putInt(String key, int value) {
        table.putNumber(key, (double)value);
    }

    public static int getInt(String key) throws TableKeyNotDefinedException {
        return (int)table.getNumber(key);
    }

    public static int getInt(String key, int defaultValue) throws TableKeyNotDefinedException {
        try {
            return (int)table.getNumber(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    public static void putDouble(String key, double value) {
        table.putNumber(key, value);
    }

    public static double getDouble(String key) throws TableKeyNotDefinedException {
        return table.getNumber(key);
    }

    public static double getDouble(String key, double defaultValue) {
        return table.getNumber(key, defaultValue);
    }
}

