/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.util;

import java.util.Vector;

public class SortedVector
extends Vector {
    Comparator comparator;

    public SortedVector(Comparator comparator) {
        this.comparator = comparator;
    }

    public void addElement(Object element) {
        int highBound = this.size();
        int lowBound = 0;
        while (highBound - lowBound > 0) {
            int index = (highBound + lowBound) / 2;
            int result = this.comparator.compare(element, this.elementAt(index));
            if (result < 0) {
                lowBound = index + 1;
                continue;
            }
            if (result > 0) {
                highBound = index;
                continue;
            }
            lowBound = index;
            highBound = index;
        }
        this.insertElementAt(element, lowBound);
    }

    public void sort() {
        Object[] array = new Object[this.size()];
        this.copyInto(array);
        this.removeAllElements();
        for (int i = 0; i < array.length; ++i) {
            this.addElement(array[i]);
        }
    }

    public static interface Comparator {
        public int compare(Object var1, Object var2);
    }
}

