/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.ros.Parameters;
import org.ros.concurrent.CancellableLoop;
import org.ros.concurrent.ListenerGroup;
import org.ros.concurrent.SignalRunnable;
import org.ros.exception.RemoteException;
import org.ros.exception.ServiceNotFoundException;
import org.ros.internal.message.service.ServiceDescription;
import org.ros.internal.message.topic.TopicDescription;
import org.ros.internal.node.RosoutLogger;
import org.ros.internal.node.client.MasterClient;
import org.ros.internal.node.client.Registrar;
import org.ros.internal.node.parameter.DefaultParameterTree;
import org.ros.internal.node.parameter.ParameterManager;
import org.ros.internal.node.response.Response;
import org.ros.internal.node.response.StatusCode;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.server.SlaveServer;
import org.ros.internal.node.service.ServiceDeclaration;
import org.ros.internal.node.service.ServiceFactory;
import org.ros.internal.node.service.ServiceIdentifier;
import org.ros.internal.node.service.ServiceManager;
import org.ros.internal.node.topic.PublisherFactory;
import org.ros.internal.node.topic.SubscriberFactory;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.node.topic.TopicParticipantManager;
import org.ros.internal.node.xmlrpc.XmlRpcTimeoutException;
import org.ros.message.MessageDeserializer;
import org.ros.message.MessageFactory;
import org.ros.message.MessageSerializationFactory;
import org.ros.message.MessageSerializer;
import org.ros.message.Time;
import org.ros.namespace.GraphName;
import org.ros.namespace.NameResolver;
import org.ros.namespace.NodeNameResolver;
import org.ros.node.ConnectedNode;
import org.ros.node.Node;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeListener;
import org.ros.node.parameter.ParameterTree;
import org.ros.node.service.ServiceClient;
import org.ros.node.service.ServiceResponseBuilder;
import org.ros.node.service.ServiceServer;
import org.ros.node.topic.DefaultPublisherListener;
import org.ros.node.topic.DefaultSubscriberListener;
import org.ros.node.topic.Publisher;
import org.ros.node.topic.PublisherListener;
import org.ros.node.topic.Subscriber;
import org.ros.node.topic.SubscriberListener;
import org.ros.time.ClockTopicTimeProvider;
import org.ros.time.TimeProvider;
import rosgraph_msgs.Clock;
import rosgraph_msgs.Log;

public class DefaultNode
implements ConnectedNode {
    private static final boolean DEBUG = false;
    private static final int MAX_SHUTDOWN_DELAY_DURATION = 5;
    private static final TimeUnit MAX_SHUTDOWN_DELAY_UNITS = TimeUnit.SECONDS;
    private final NodeConfiguration nodeConfiguration;
    private final ListenerGroup<NodeListener> nodeListeners;
    private final ScheduledExecutorService scheduledExecutorService;
    private final URI masterUri;
    private final MasterClient masterClient;
    private final TopicParticipantManager topicParticipantManager;
    private final ServiceManager serviceManager;
    private final ParameterManager parameterManager;
    private final GraphName nodeName;
    private final NodeNameResolver resolver;
    private final SlaveServer slaveServer;
    private final ParameterTree parameterTree;
    private final PublisherFactory publisherFactory;
    private final SubscriberFactory subscriberFactory;
    private final ServiceFactory serviceFactory;
    private final Registrar registrar;
    private RosoutLogger log;
    private TimeProvider timeProvider;

    public DefaultNode(NodeConfiguration nodeConfiguration, Collection<NodeListener> nodeListeners, ScheduledExecutorService scheduledExecutorService) {
        this.nodeConfiguration = NodeConfiguration.copyOf(nodeConfiguration);
        this.nodeListeners = new ListenerGroup(scheduledExecutorService);
        this.nodeListeners.addAll(nodeListeners);
        this.scheduledExecutorService = scheduledExecutorService;
        this.masterUri = nodeConfiguration.getMasterUri();
        this.masterClient = new MasterClient(this.masterUri);
        this.topicParticipantManager = new TopicParticipantManager();
        this.serviceManager = new ServiceManager();
        this.parameterManager = new ParameterManager(scheduledExecutorService);
        GraphName basename = nodeConfiguration.getNodeName();
        NameResolver parentResolver = nodeConfiguration.getParentResolver();
        this.nodeName = parentResolver.getNamespace().join(basename);
        this.resolver = new NodeNameResolver(this.nodeName, parentResolver);
        this.slaveServer = new SlaveServer(this.nodeName, nodeConfiguration.getTcpRosBindAddress(), nodeConfiguration.getTcpRosAdvertiseAddress(), nodeConfiguration.getXmlRpcBindAddress(), nodeConfiguration.getXmlRpcAdvertiseAddress(), this.masterClient, this.topicParticipantManager, this.serviceManager, this.parameterManager, scheduledExecutorService);
        this.slaveServer.start();
        NodeIdentifier nodeIdentifier = this.slaveServer.toNodeIdentifier();
        this.parameterTree = DefaultParameterTree.newFromNodeIdentifier(nodeIdentifier, this.masterClient.getRemoteUri(), this.resolver, this.parameterManager);
        this.publisherFactory = new PublisherFactory(nodeIdentifier, this.topicParticipantManager, nodeConfiguration.getTopicMessageFactory(), scheduledExecutorService);
        this.subscriberFactory = new SubscriberFactory(nodeIdentifier, this.topicParticipantManager, scheduledExecutorService);
        this.serviceFactory = new ServiceFactory(this.nodeName, this.slaveServer, this.serviceManager, scheduledExecutorService);
        this.registrar = new Registrar(this.masterClient, scheduledExecutorService);
        this.topicParticipantManager.setListener(this.registrar);
        this.serviceManager.setListener(this.registrar);
        scheduledExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                DefaultNode.this.start();
            }
        });
    }

    private void start() {
        this.registrar.start(this.slaveServer.toNodeIdentifier());
        final CountDownLatch latch = new CountDownLatch(2);
        this.log = new RosoutLogger(this);
        this.log.getPublisher().addListener((PublisherListener<Log>)new DefaultPublisherListener<Log>(){

            @Override
            public void onMasterRegistrationSuccess(Publisher<Log> registrant) {
                latch.countDown();
            }
        });
        boolean useSimTime = false;
        try {
            useSimTime = this.parameterTree.has(Parameters.USE_SIM_TIME) && this.parameterTree.getBoolean(Parameters.USE_SIM_TIME);
        }
        catch (Exception e) {
            this.signalOnError(e);
        }
        if (useSimTime) {
            ClockTopicTimeProvider clockTopicTimeProvider = new ClockTopicTimeProvider(this);
            clockTopicTimeProvider.getSubscriber().addSubscriberListener((SubscriberListener<Clock>)new DefaultSubscriberListener<Clock>(){

                @Override
                public void onMasterRegistrationSuccess(Subscriber<Clock> subscriber) {
                    latch.countDown();
                }
            });
            this.timeProvider = clockTopicTimeProvider;
        } else {
            this.timeProvider = this.nodeConfiguration.getTimeProvider();
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.signalOnError(e);
            this.shutdown();
            return;
        }
        this.signalOnStart();
    }

    @VisibleForTesting
    Registrar getRegistrar() {
        return this.registrar;
    }

    private <T> MessageSerializer<T> newMessageSerializer(String messageType) {
        return this.nodeConfiguration.getMessageSerializationFactory().newMessageSerializer(messageType);
    }

    private <T> MessageDeserializer<T> newMessageDeserializer(String messageType) {
        return this.nodeConfiguration.getMessageSerializationFactory().newMessageDeserializer(messageType);
    }

    private <T> MessageSerializer<T> newServiceResponseSerializer(String serviceType) {
        return this.nodeConfiguration.getMessageSerializationFactory().newServiceResponseSerializer(serviceType);
    }

    private <T> MessageDeserializer<T> newServiceResponseDeserializer(String serviceType) {
        return this.nodeConfiguration.getMessageSerializationFactory().newServiceResponseDeserializer(serviceType);
    }

    private <T> MessageSerializer<T> newServiceRequestSerializer(String serviceType) {
        return this.nodeConfiguration.getMessageSerializationFactory().newServiceRequestSerializer(serviceType);
    }

    private <T> MessageDeserializer<T> newServiceRequestDeserializer(String serviceType) {
        return this.nodeConfiguration.getMessageSerializationFactory().newServiceRequestDeserializer(serviceType);
    }

    @Override
    public <T> Publisher<T> newPublisher(GraphName topicName, String messageType) {
        GraphName resolvedTopicName = this.resolveName(topicName);
        TopicDescription topicDescription = this.nodeConfiguration.getTopicDescriptionFactory().newFromType(messageType);
        TopicDeclaration topicDeclaration = TopicDeclaration.newFromTopicName(resolvedTopicName, topicDescription);
        MessageSerializer<T> serializer = this.newMessageSerializer(messageType);
        return this.publisherFactory.newOrExisting(topicDeclaration, serializer);
    }

    @Override
    public <T> Publisher<T> newPublisher(String topicName, String messageType) {
        return this.newPublisher(GraphName.of(topicName), messageType);
    }

    @Override
    public <T> Subscriber<T> newSubscriber(GraphName topicName, String messageType) {
        GraphName resolvedTopicName = this.resolveName(topicName);
        TopicDescription topicDescription = this.nodeConfiguration.getTopicDescriptionFactory().newFromType(messageType);
        TopicDeclaration topicDeclaration = TopicDeclaration.newFromTopicName(resolvedTopicName, topicDescription);
        MessageDeserializer<T> deserializer = this.newMessageDeserializer(messageType);
        Subscriber<T> subscriber = this.subscriberFactory.newOrExisting(topicDeclaration, deserializer);
        return subscriber;
    }

    @Override
    public <T> Subscriber<T> newSubscriber(String topicName, String messageType) {
        return this.newSubscriber(GraphName.of(topicName), messageType);
    }

    @Override
    public <T, S> ServiceServer<T, S> newServiceServer(GraphName serviceName, String serviceType, ServiceResponseBuilder<T, S> responseBuilder) {
        GraphName resolvedServiceName = this.resolveName(serviceName);
        ServiceIdentifier identifier = new ServiceIdentifier(resolvedServiceName, null);
        ServiceDescription serviceDescription = this.nodeConfiguration.getServiceDescriptionFactory().newFromType(serviceType);
        ServiceDeclaration definition = new ServiceDeclaration(identifier, serviceDescription);
        MessageDeserializer<T> requestDeserializer = this.newServiceRequestDeserializer(serviceType);
        MessageSerializer<T> responseSerializer = this.newServiceResponseSerializer(serviceType);
        return this.serviceFactory.newServer(definition, responseBuilder, requestDeserializer, responseSerializer, this.nodeConfiguration.getServiceResponseMessageFactory());
    }

    @Override
    public <T, S> ServiceServer<T, S> newServiceServer(String serviceName, String serviceType, ServiceResponseBuilder<T, S> responseBuilder) {
        return this.newServiceServer(GraphName.of(serviceName), serviceType, responseBuilder);
    }

    @Override
    public <T, S> ServiceServer<T, S> getServiceServer(GraphName serviceName) {
        return this.serviceManager.getServer(serviceName);
    }

    @Override
    public <T, S> ServiceServer<T, S> getServiceServer(String serviceName) {
        return this.getServiceServer(GraphName.of(serviceName));
    }

    @Override
    public URI lookupServiceUri(GraphName serviceName) {
        Response<URI> response = this.masterClient.lookupService(this.slaveServer.toNodeIdentifier().getName(), this.resolveName(serviceName).toString());
        if (response.getStatusCode() == StatusCode.SUCCESS) {
            return response.getResult();
        }
        return null;
    }

    @Override
    public URI lookupServiceUri(String serviceName) {
        return this.lookupServiceUri(GraphName.of(serviceName));
    }

    @Override
    public <T, S> ServiceClient<T, S> newServiceClient(GraphName serviceName, String serviceType) throws ServiceNotFoundException {
        GraphName resolvedServiceName = this.resolveName(serviceName);
        URI uri = this.lookupServiceUri(resolvedServiceName);
        if (uri == null) {
            throw new ServiceNotFoundException("No such service " + resolvedServiceName + " of type " + serviceType);
        }
        ServiceDescription serviceDescription = this.nodeConfiguration.getServiceDescriptionFactory().newFromType(serviceType);
        ServiceIdentifier serviceIdentifier = new ServiceIdentifier(resolvedServiceName, uri);
        ServiceDeclaration definition = new ServiceDeclaration(serviceIdentifier, serviceDescription);
        MessageSerializer<T> requestSerializer = this.newServiceRequestSerializer(serviceType);
        MessageDeserializer<T> responseDeserializer = this.newServiceResponseDeserializer(serviceType);
        return this.serviceFactory.newClient(definition, requestSerializer, responseDeserializer, this.nodeConfiguration.getServiceRequestMessageFactory());
    }

    @Override
    public <T, S> ServiceClient<T, S> newServiceClient(String serviceName, String serviceType) throws ServiceNotFoundException {
        return this.newServiceClient(GraphName.of(serviceName), serviceType);
    }

    @Override
    public Time getCurrentTime() {
        return this.timeProvider.getCurrentTime();
    }

    @Override
    public GraphName getName() {
        return this.nodeName;
    }

    @Override
    public org.apache.commons.logging.Log getLog() {
        return this.log;
    }

    @Override
    public GraphName resolveName(GraphName name) {
        return this.resolver.resolve(name);
    }

    @Override
    public GraphName resolveName(String name) {
        return this.resolver.resolve(GraphName.of(name));
    }

    @Override
    public void shutdown() {
        this.signalOnShutdown();
        for (Publisher publisher : this.topicParticipantManager.getPublishers()) {
            publisher.shutdown();
        }
        for (Subscriber subscriber : this.topicParticipantManager.getSubscribers()) {
            subscriber.shutdown();
        }
        for (ServiceServer serviceServer : this.serviceManager.getServers()) {
            try {
                Response<Integer> response = this.masterClient.unregisterService(this.slaveServer.toNodeIdentifier(), serviceServer);
            }
            catch (XmlRpcTimeoutException e) {
                this.log.error(e);
            }
            catch (RemoteException e) {
                this.log.error(e);
            }
        }
        for (ServiceClient serviceClient : this.serviceManager.getClients()) {
            serviceClient.shutdown();
        }
        this.registrar.shutdown();
        this.slaveServer.shutdown();
        this.signalOnShutdownComplete();
    }

    @Override
    public URI getMasterUri() {
        return this.masterUri;
    }

    @Override
    public NodeNameResolver getResolver() {
        return this.resolver;
    }

    @Override
    public ParameterTree getParameterTree() {
        return this.parameterTree;
    }

    @Override
    public URI getUri() {
        return this.slaveServer.getUri();
    }

    @Override
    public MessageSerializationFactory getMessageSerializationFactory() {
        return this.nodeConfiguration.getMessageSerializationFactory();
    }

    @Override
    public MessageFactory getTopicMessageFactory() {
        return this.nodeConfiguration.getTopicMessageFactory();
    }

    @Override
    public MessageFactory getServiceRequestMessageFactory() {
        return this.nodeConfiguration.getServiceRequestMessageFactory();
    }

    @Override
    public MessageFactory getServiceResponseMessageFactory() {
        return this.nodeConfiguration.getServiceResponseMessageFactory();
    }

    @Override
    public void addListener(NodeListener listener) {
        this.nodeListeners.add(listener);
    }

    private void signalOnError(final Throwable throwable) {
        final DefaultNode node = this;
        this.nodeListeners.signal(new SignalRunnable<NodeListener>(){

            @Override
            public void run(NodeListener listener) {
                listener.onError(node, throwable);
            }
        });
    }

    private void signalOnStart() {
        final DefaultNode connectedNode = this;
        this.nodeListeners.signal(new SignalRunnable<NodeListener>(){

            @Override
            public void run(NodeListener listener) {
                listener.onStart(connectedNode);
            }
        });
    }

    private void signalOnShutdown() {
        final DefaultNode node = this;
        try {
            this.nodeListeners.signal(new SignalRunnable<NodeListener>(){

                @Override
                public void run(NodeListener listener) {
                    listener.onShutdown(node);
                }
            }, 5L, MAX_SHUTDOWN_DELAY_UNITS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void signalOnShutdownComplete() {
        final DefaultNode node = this;
        this.nodeListeners.signal(new SignalRunnable<NodeListener>(){

            @Override
            public void run(NodeListener listener) {
                try {
                    listener.onShutdownComplete(node);
                }
                catch (Throwable e) {
                    System.out.println(listener);
                }
            }
        });
    }

    @VisibleForTesting
    InetSocketAddress getAddress() {
        return this.slaveServer.getAddress();
    }

    @Override
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void executeCancellableLoop(final CancellableLoop cancellableLoop) {
        this.scheduledExecutorService.execute(cancellableLoop);
        this.addListener(new NodeListener(){

            @Override
            public void onStart(ConnectedNode connectedNode) {
            }

            @Override
            public void onShutdown(Node node) {
                cancellableLoop.cancel();
            }

            @Override
            public void onShutdownComplete(Node node) {
            }

            @Override
            public void onError(Node node, Throwable throwable) {
                cancellableLoop.cancel();
            }
        });
    }
}

