/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.ros.address.AdvertiseAddress;
import org.ros.address.BindAddress;
import org.ros.internal.node.client.MasterClient;
import org.ros.internal.node.parameter.ParameterManager;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.server.ServerException;
import org.ros.internal.node.server.XmlRpcServer;
import org.ros.internal.node.service.ServiceManager;
import org.ros.internal.node.topic.DefaultPublisher;
import org.ros.internal.node.topic.DefaultSubscriber;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.node.topic.TopicParticipantManager;
import org.ros.internal.node.xmlrpc.SlaveXmlRpcEndpointImpl;
import org.ros.internal.system.Process;
import org.ros.internal.transport.ProtocolDescription;
import org.ros.internal.transport.tcp.TcpRosProtocolDescription;
import org.ros.internal.transport.tcp.TcpRosServer;
import org.ros.namespace.GraphName;

public class SlaveServer
extends XmlRpcServer {
    private final GraphName nodeName;
    private final MasterClient masterClient;
    private final TopicParticipantManager topicParticipantManager;
    private final ParameterManager parameterManager;
    private final TcpRosServer tcpRosServer;

    public SlaveServer(GraphName nodeName, BindAddress tcpRosBindAddress, AdvertiseAddress tcpRosAdvertiseAddress, BindAddress xmlRpcBindAddress, AdvertiseAddress xmlRpcAdvertiseAddress, MasterClient master, TopicParticipantManager topicParticipantManager, ServiceManager serviceManager, ParameterManager parameterManager, ScheduledExecutorService executorService) {
        super(xmlRpcBindAddress, xmlRpcAdvertiseAddress);
        this.nodeName = nodeName;
        this.masterClient = master;
        this.topicParticipantManager = topicParticipantManager;
        this.parameterManager = parameterManager;
        this.tcpRosServer = new TcpRosServer(tcpRosBindAddress, tcpRosAdvertiseAddress, topicParticipantManager, serviceManager, executorService);
    }

    public AdvertiseAddress getTcpRosAdvertiseAddress() {
        return this.tcpRosServer.getAdvertiseAddress();
    }

    public void start() {
        super.start(SlaveXmlRpcEndpointImpl.class, new SlaveXmlRpcEndpointImpl(this));
        this.tcpRosServer.start();
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.tcpRosServer.shutdown();
    }

    public List<Object> getBusStats(String callerId) {
        throw new UnsupportedOperationException();
    }

    public List<Object> getBusInfo(String callerId) {
        ArrayList busInfo = Lists.newArrayList();
        int id = 0;
        for (DefaultPublisher<?> defaultPublisher : this.getPublications()) {
            for (SubscriberIdentifier subscriberIdentifier : this.topicParticipantManager.getPublisherConnections(defaultPublisher)) {
                ArrayList publisherBusInfo = Lists.newArrayList();
                publisherBusInfo.add(Integer.toString(id));
                publisherBusInfo.add(subscriberIdentifier.getNodeIdentifier().getName().toString());
                publisherBusInfo.add("o");
                publisherBusInfo.add("TCPROS");
                publisherBusInfo.add(defaultPublisher.getTopicName().toString());
                busInfo.add(publisherBusInfo);
                ++id;
            }
        }
        for (DefaultSubscriber defaultSubscriber : this.getSubscriptions()) {
            for (PublisherIdentifier publisherIdentifer : this.topicParticipantManager.getSubscriberConnections(defaultSubscriber)) {
                ArrayList subscriberBusInfo = Lists.newArrayList();
                subscriberBusInfo.add(Integer.toString(id));
                subscriberBusInfo.add(publisherIdentifer.getNodeIdentifier().getUri().toString());
                subscriberBusInfo.add("i");
                subscriberBusInfo.add("TCPROS");
                subscriberBusInfo.add(publisherIdentifer.getTopicName().toString());
                busInfo.add(subscriberBusInfo);
                ++id;
            }
        }
        return busInfo;
    }

    public URI getMasterUri() {
        return this.masterClient.getRemoteUri();
    }

    @Override
    public int getPid() {
        return Process.getPid();
    }

    public Collection<DefaultSubscriber<?>> getSubscriptions() {
        return this.topicParticipantManager.getSubscribers();
    }

    public Collection<DefaultPublisher<?>> getPublications() {
        return this.topicParticipantManager.getPublishers();
    }

    public int paramUpdate(GraphName parameterName, Object parameterValue) {
        return this.parameterManager.updateParameter(parameterName, parameterValue);
    }

    public void publisherUpdate(String callerId, String topicName, Collection<URI> publisherUris) {
        GraphName graphName = GraphName.of(topicName);
        if (this.topicParticipantManager.hasSubscriber(graphName)) {
            DefaultSubscriber<?> subscriber = this.topicParticipantManager.getSubscriber(graphName);
            TopicDeclaration topicDeclaration = subscriber.getTopicDeclaration();
            Collection<PublisherIdentifier> identifiers = PublisherIdentifier.newCollectionFromUris(publisherUris, topicDeclaration);
            subscriber.updatePublishers(identifiers);
        }
    }

    public ProtocolDescription requestTopic(String topicName, Collection<String> protocols) throws ServerException {
        GraphName graphName = GraphName.of(topicName).toGlobal();
        if (!this.topicParticipantManager.hasPublisher(graphName)) {
            throw new ServerException("No publishers for topic: " + graphName);
        }
        for (String protocol : protocols) {
            if (!protocol.equals("TCPROS")) continue;
            try {
                return new TcpRosProtocolDescription(this.tcpRosServer.getAdvertiseAddress());
            }
            catch (Exception e) {
                throw new ServerException(e);
            }
        }
        throw new ServerException("No supported protocols specified.");
    }

    public NodeIdentifier toNodeIdentifier() {
        return new NodeIdentifier(this.nodeName, this.getUri());
    }
}

