/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server.master;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.internal.node.server.master.MasterRegistrationListener;
import org.ros.internal.node.server.master.NodeRegistrationInfo;
import org.ros.internal.node.server.master.ServiceRegistrationInfo;
import org.ros.internal.node.server.master.TopicRegistrationInfo;
import org.ros.namespace.GraphName;

public class MasterRegistrationManagerImpl {
    private static final Log log = LogFactory.getLog(MasterRegistrationManagerImpl.class);
    private final Map<GraphName, NodeRegistrationInfo> nodes;
    private final Map<GraphName, ServiceRegistrationInfo> services;
    private final Map<GraphName, TopicRegistrationInfo> topics;
    private final MasterRegistrationListener listener;

    public MasterRegistrationManagerImpl(MasterRegistrationListener listener) {
        this.listener = listener;
        this.nodes = Maps.newHashMap();
        this.services = Maps.newConcurrentMap();
        this.topics = Maps.newHashMap();
    }

    public TopicRegistrationInfo registerPublisher(GraphName nodeName, URI nodeSlaveUri, GraphName topicName, String topicMessageType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Registering publisher topic %s with message type %s on node %s with slave URI %s", topicName, topicMessageType, nodeName, nodeSlaveUri));
        }
        TopicRegistrationInfo topic = this.obtainTopicRegistrationInfo(topicName, true);
        NodeRegistrationInfo node = this.obtainNodeRegistrationInfo(nodeName, nodeSlaveUri);
        topic.addPublisher(node, topicMessageType);
        node.addPublisher(topic);
        return topic;
    }

    public boolean unregisterPublisher(GraphName nodeName, GraphName topicName) {
        TopicRegistrationInfo topic;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unregistering publisher of topic %s from node %s", topicName, nodeName));
        }
        if ((topic = this.obtainTopicRegistrationInfo(topicName, false)) != null) {
            NodeRegistrationInfo node = this.nodes.get(nodeName);
            if (node != null) {
                node.removePublisher(topic);
                topic.removePublisher(node);
                this.potentiallyDeleteNode(node);
                return true;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Received unregister publisher for topic %s on unknown node %s", topicName, nodeName));
            }
            return false;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("Received unregister publisher for unknown topic %s on node %s", topicName, nodeName));
        }
        return false;
    }

    public TopicRegistrationInfo registerSubscriber(GraphName nodeName, URI nodeSlaveUri, GraphName topicName, String topicMessageType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Registering subscriber topic %s with message type %s on node %s with slave URI %s", topicName, topicMessageType, nodeName, nodeSlaveUri));
        }
        TopicRegistrationInfo topic = this.obtainTopicRegistrationInfo(topicName, true);
        NodeRegistrationInfo node = this.obtainNodeRegistrationInfo(nodeName, nodeSlaveUri);
        topic.addSubscriber(node, topicMessageType);
        node.addSubscriber(topic);
        return topic;
    }

    public boolean unregisterSubscriber(GraphName nodeName, GraphName topicName) {
        TopicRegistrationInfo topic;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unregistering subscriber of topic %s from node %s", topicName, nodeName));
        }
        if ((topic = this.obtainTopicRegistrationInfo(topicName, false)) != null) {
            NodeRegistrationInfo node = this.nodes.get(nodeName);
            if (node != null) {
                node.removeSubscriber(topic);
                topic.removeSubscriber(node);
                this.potentiallyDeleteNode(node);
                return true;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Received unregister subscriber for topic %s on unknown node %s", topicName, nodeName));
            }
            return false;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("Received unregister subscriber for unknown topic %s on node %s", topicName, nodeName));
        }
        return false;
    }

    public ServiceRegistrationInfo registerService(GraphName nodeName, URI nodeSlaveUri, GraphName serviceName, URI serviceUri) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Registering service %s with server URI %s on node %s with slave URI %s", serviceName, serviceUri, nodeName, nodeSlaveUri));
        }
        NodeRegistrationInfo node = this.obtainNodeRegistrationInfo(nodeName, nodeSlaveUri);
        ServiceRegistrationInfo service = this.services.get(serviceName);
        if (service != null) {
            NodeRegistrationInfo previousServiceNode = service.getNode();
            if (previousServiceNode == node) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)String.format("Registering already known service %s with server URI %s on node %s with slave URI %s", serviceName, serviceUri, nodeName, nodeSlaveUri));
                }
                return service;
            }
            previousServiceNode.removeService(service);
            this.potentiallyDeleteNode(previousServiceNode);
        }
        service = new ServiceRegistrationInfo(serviceName, serviceUri, node);
        node.addService(service);
        this.services.put(serviceName, service);
        return service;
    }

    public boolean unregisterService(GraphName nodeName, GraphName serviceName, URI serviceUri) {
        ServiceRegistrationInfo service;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Unregistering service %s from node %s", serviceName, nodeName));
        }
        if ((service = this.services.get(serviceName)) != null) {
            NodeRegistrationInfo node = this.nodes.get(nodeName);
            if (node != null) {
                this.services.remove(serviceName);
                node.removeService(service);
                this.potentiallyDeleteNode(node);
                return true;
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)String.format("Received unregister for service %s on unknown node %s", serviceName, nodeName));
            }
            return false;
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)String.format("Received unregister for unknown service %s on node %s", serviceName, nodeName));
        }
        return false;
    }

    public Collection<TopicRegistrationInfo> getAllTopics() {
        return Collections.unmodifiableCollection(this.topics.values());
    }

    public TopicRegistrationInfo getTopicRegistrationInfo(GraphName topicName) {
        return this.topics.get(topicName);
    }

    public NodeRegistrationInfo getNodeRegistrationInfo(GraphName nodeName) {
        return this.nodes.get(nodeName);
    }

    public Collection<ServiceRegistrationInfo> getAllServices() {
        return Collections.unmodifiableCollection(this.services.values());
    }

    public ServiceRegistrationInfo getServiceRegistrationInfo(GraphName serviceName) {
        return this.services.get(serviceName);
    }

    private TopicRegistrationInfo obtainTopicRegistrationInfo(GraphName topicName, boolean shouldCreate) {
        TopicRegistrationInfo info = this.topics.get(topicName);
        if (info == null && shouldCreate) {
            info = new TopicRegistrationInfo(topicName);
            this.topics.put(topicName, info);
        }
        return info;
    }

    private NodeRegistrationInfo obtainNodeRegistrationInfo(GraphName nodeName, URI nodeSlaveUri) {
        NodeRegistrationInfo node = this.nodes.get(nodeName);
        if (node != null) {
            if (node.getNodeSlaveUri().equals(nodeSlaveUri)) {
                return node;
            }
            this.potentiallyDeleteNode(node);
            this.cleanupNode(node);
            try {
                this.listener.onNodeReplacement(node);
            }
            catch (Exception e) {
                log.error((Object)"Error during onNodeReplacement call", (Throwable)e);
            }
        }
        node = new NodeRegistrationInfo(nodeName, nodeSlaveUri);
        this.nodes.put(nodeName, node);
        return node;
    }

    private void cleanupNode(NodeRegistrationInfo node) {
        for (TopicRegistrationInfo topic : node.getPublishers()) {
            topic.removePublisher(node);
        }
        for (TopicRegistrationInfo topic : node.getSubscribers()) {
            topic.removeSubscriber(node);
        }
        for (ServiceRegistrationInfo service : node.getServices()) {
            this.services.remove(service.getServiceName());
        }
    }

    private void potentiallyDeleteNode(NodeRegistrationInfo node) {
        if (!node.hasRegistrations()) {
            this.nodes.remove(node.getNodeName());
        }
    }
}

