/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.server.master;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import org.ros.internal.node.server.master.NodeRegistrationInfo;
import org.ros.namespace.GraphName;

public class TopicRegistrationInfo {
    private final GraphName topicName;
    private String messageType;
    private boolean isPublisherDefinedMessageType;
    private final Set<NodeRegistrationInfo> publishers;
    private final Set<NodeRegistrationInfo> subscribers;

    public TopicRegistrationInfo(GraphName topicName) {
        this.topicName = topicName;
        this.publishers = Sets.newHashSet();
        this.subscribers = Sets.newHashSet();
        this.isPublisherDefinedMessageType = false;
    }

    public GraphName getTopicName() {
        return this.topicName;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public boolean hasPublishers() {
        return !this.publishers.isEmpty();
    }

    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    public boolean hasRegistrations() {
        return this.hasPublishers() || this.hasSubscribers();
    }

    public Set<NodeRegistrationInfo> getPublishers() {
        return ImmutableSet.copyOf(this.publishers);
    }

    public void addPublisher(NodeRegistrationInfo publisher, String messageType) {
        Preconditions.checkNotNull((Object)publisher);
        this.publishers.add(publisher);
        this.setMessageType(messageType, true);
    }

    public boolean removePublisher(NodeRegistrationInfo publisher) {
        return this.publishers.remove(publisher);
    }

    public Set<NodeRegistrationInfo> getSubscribers() {
        return ImmutableSet.copyOf(this.subscribers);
    }

    public void addSubscriber(NodeRegistrationInfo subscriber, String messageType) {
        Preconditions.checkNotNull((Object)subscriber);
        this.subscribers.add(subscriber);
        this.setMessageType(messageType, false);
    }

    public boolean removeSubscriber(NodeRegistrationInfo subscriber) {
        return this.subscribers.remove(subscriber);
    }

    private void setMessageType(String topicMessageType, boolean isPublisher) {
        if (isPublisher) {
            this.messageType = topicMessageType;
            this.isPublisherDefinedMessageType = true;
        } else if (!"*".equals(topicMessageType)) {
            if (this.messageType != null) {
                if (!this.isPublisherDefinedMessageType) {
                    this.messageType = topicMessageType;
                }
            } else {
                this.messageType = topicMessageType;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.topicName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TopicRegistrationInfo other = (TopicRegistrationInfo)obj;
        return this.topicName.equals(other.topicName);
    }
}

