/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelHandler;
import org.ros.address.AdvertiseAddress;
import org.ros.concurrent.ListenerGroup;
import org.ros.concurrent.SignalRunnable;
import org.ros.internal.message.service.ServiceDescription;
import org.ros.internal.node.service.ServiceDeclaration;
import org.ros.internal.node.service.ServiceIdentifier;
import org.ros.internal.node.service.ServiceRequestHandler;
import org.ros.internal.node.topic.DefaultPublisher;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.message.MessageDeserializer;
import org.ros.message.MessageFactory;
import org.ros.message.MessageSerializer;
import org.ros.namespace.GraphName;
import org.ros.node.service.DefaultServiceServerListener;
import org.ros.node.service.ServiceResponseBuilder;
import org.ros.node.service.ServiceServer;
import org.ros.node.service.ServiceServerListener;

public class DefaultServiceServer<T, S>
implements ServiceServer<T, S> {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(DefaultPublisher.class);
    private final ServiceDeclaration serviceDeclaration;
    private final ServiceResponseBuilder<T, S> serviceResponseBuilder;
    private final AdvertiseAddress advertiseAddress;
    private final MessageDeserializer<T> messageDeserializer;
    private final MessageSerializer<S> messageSerializer;
    private final MessageFactory messageFactory;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ListenerGroup<ServiceServerListener<T, S>> listenerGroup;

    public DefaultServiceServer(ServiceDeclaration serviceDeclaration, ServiceResponseBuilder<T, S> serviceResponseBuilder, AdvertiseAddress advertiseAddress, MessageDeserializer<T> messageDeserializer, MessageSerializer<S> messageSerializer, MessageFactory messageFactory, ScheduledExecutorService scheduledExecutorService) {
        this.serviceDeclaration = serviceDeclaration;
        this.serviceResponseBuilder = serviceResponseBuilder;
        this.advertiseAddress = advertiseAddress;
        this.messageDeserializer = messageDeserializer;
        this.messageSerializer = messageSerializer;
        this.messageFactory = messageFactory;
        this.scheduledExecutorService = scheduledExecutorService;
        this.listenerGroup = new ListenerGroup(scheduledExecutorService);
        this.listenerGroup.add(new DefaultServiceServerListener<T, S>(){

            @Override
            public void onMasterRegistrationSuccess(ServiceServer<T, S> registrant) {
                log.info((Object)("Service registered: " + DefaultServiceServer.this));
            }

            @Override
            public void onMasterRegistrationFailure(ServiceServer<T, S> registrant) {
                log.info((Object)("Service registration failed: " + DefaultServiceServer.this));
            }

            @Override
            public void onMasterUnregistrationSuccess(ServiceServer<T, S> registrant) {
                log.info((Object)("Service unregistered: " + DefaultServiceServer.this));
            }

            @Override
            public void onMasterUnregistrationFailure(ServiceServer<T, S> registrant) {
                log.info((Object)("Service unregistration failed: " + DefaultServiceServer.this));
            }
        });
    }

    public ChannelBuffer finishHandshake(ConnectionHeader incomingConnectionHeader) {
        ConnectionHeader connectionHeader = this.toDeclaration().toConnectionHeader();
        String expectedChecksum = connectionHeader.getField("md5sum");
        String incomingChecksum = incomingConnectionHeader.getField("md5sum");
        Preconditions.checkState((incomingChecksum.equals(expectedChecksum) || incomingChecksum.equals("*") ? 1 : 0) != 0);
        return connectionHeader.encode();
    }

    @Override
    public URI getUri() {
        return this.advertiseAddress.toUri("rosrpc");
    }

    @Override
    public GraphName getName() {
        return this.serviceDeclaration.getName();
    }

    ServiceDeclaration toDeclaration() {
        ServiceIdentifier identifier = new ServiceIdentifier(this.serviceDeclaration.getName(), this.getUri());
        return new ServiceDeclaration(identifier, new ServiceDescription(this.serviceDeclaration.getType(), this.serviceDeclaration.getDefinition(), this.serviceDeclaration.getMd5Checksum()));
    }

    public ChannelHandler newRequestHandler() {
        return new ServiceRequestHandler<T, S>(this.serviceDeclaration, this.serviceResponseBuilder, this.messageDeserializer, this.messageSerializer, this.messageFactory, this.scheduledExecutorService);
    }

    public void signalOnMasterRegistrationSuccess() {
        final DefaultServiceServer serviceServer = this;
        this.listenerGroup.signal(new SignalRunnable<ServiceServerListener<T, S>>(){

            @Override
            public void run(ServiceServerListener<T, S> listener) {
                listener.onMasterRegistrationSuccess(serviceServer);
            }
        });
    }

    public void signalOnMasterRegistrationFailure() {
        final DefaultServiceServer serviceServer = this;
        this.listenerGroup.signal(new SignalRunnable<ServiceServerListener<T, S>>(){

            @Override
            public void run(ServiceServerListener<T, S> listener) {
                listener.onMasterRegistrationFailure(serviceServer);
            }
        });
    }

    public void signalOnMasterUnregistrationSuccess() {
        final DefaultServiceServer serviceServer = this;
        this.listenerGroup.signal(new SignalRunnable<ServiceServerListener<T, S>>(){

            @Override
            public void run(ServiceServerListener<T, S> listener) {
                listener.onMasterUnregistrationSuccess(serviceServer);
            }
        });
    }

    public void signalOnMasterUnregistrationFailure() {
        final DefaultServiceServer serviceServer = this;
        this.listenerGroup.signal(new SignalRunnable<ServiceServerListener<T, S>>(){

            @Override
            public void run(ServiceServerListener<T, S> listener) {
                listener.onMasterUnregistrationFailure(serviceServer);
            }
        });
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addListener(ServiceServerListener<T, S> listener) {
        this.listenerGroup.add(listener);
    }

    public String toString() {
        return "ServiceServer<" + this.toDeclaration() + ">";
    }
}

