/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import com.google.common.base.Preconditions;
import java.util.concurrent.ScheduledExecutorService;
import org.ros.exception.DuplicateServiceException;
import org.ros.internal.node.server.SlaveServer;
import org.ros.internal.node.service.DefaultServiceClient;
import org.ros.internal.node.service.DefaultServiceServer;
import org.ros.internal.node.service.ServiceDeclaration;
import org.ros.internal.node.service.ServiceManager;
import org.ros.message.MessageDeserializer;
import org.ros.message.MessageFactory;
import org.ros.message.MessageSerializer;
import org.ros.namespace.GraphName;
import org.ros.node.service.ServiceResponseBuilder;

public class ServiceFactory {
    private final GraphName nodeName;
    private final SlaveServer slaveServer;
    private final ServiceManager serviceManager;
    private final ScheduledExecutorService executorService;
    private final Object mutex;

    public ServiceFactory(GraphName nodeName, SlaveServer slaveServer, ServiceManager serviceManager, ScheduledExecutorService executorService) {
        this.nodeName = nodeName;
        this.slaveServer = slaveServer;
        this.serviceManager = serviceManager;
        this.executorService = executorService;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, S> DefaultServiceServer<T, S> newServer(ServiceDeclaration serviceDeclaration, ServiceResponseBuilder<T, S> responseBuilder, MessageDeserializer<T> deserializer, MessageSerializer<S> serializer, MessageFactory messageFactory) {
        DefaultServiceServer<T, S> serviceServer;
        GraphName name = serviceDeclaration.getName();
        Object object = this.mutex;
        synchronized (object) {
            if (this.serviceManager.hasServer(name)) {
                throw new DuplicateServiceException(String.format("ServiceServer %s already exists.", name));
            }
            serviceServer = new DefaultServiceServer<T, S>(serviceDeclaration, responseBuilder, this.slaveServer.getTcpRosAdvertiseAddress(), deserializer, serializer, messageFactory, this.executorService);
            this.serviceManager.addServer(serviceServer);
        }
        return serviceServer;
    }

    public <T, S> DefaultServiceServer<T, S> getServer(GraphName name) {
        if (this.serviceManager.hasServer(name)) {
            return this.serviceManager.getServer(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, S> DefaultServiceClient<T, S> newClient(ServiceDeclaration serviceDeclaration, MessageSerializer<T> serializer, MessageDeserializer<S> deserializer, MessageFactory messageFactory) {
        DefaultServiceClient<Object, Object> serviceClient;
        Preconditions.checkNotNull((Object)serviceDeclaration.getUri());
        GraphName name = serviceDeclaration.getName();
        boolean createdNewClient = false;
        Object object = this.mutex;
        synchronized (object) {
            if (this.serviceManager.hasClient(name)) {
                serviceClient = this.serviceManager.getClient(name);
            } else {
                serviceClient = DefaultServiceClient.newDefault(this.nodeName, serviceDeclaration, serializer, deserializer, messageFactory, this.executorService);
                this.serviceManager.addClient(serviceClient);
                createdNewClient = true;
            }
        }
        if (createdNewClient) {
            serviceClient.connect(serviceDeclaration.getUri());
        }
        return serviceClient;
    }
}

