/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.ros.namespace.GraphName;

public class ServiceIdentifier {
    private final GraphName name;
    private final URI uri;

    public ServiceIdentifier(GraphName name, URI uri) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkArgument((boolean)name.isGlobal());
        this.name = name;
        this.uri = uri;
    }

    public GraphName getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return "ServiceIdentifier<" + this.name + ", " + this.uri + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceIdentifier other = (ServiceIdentifier)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

