/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.service;

import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.ros.internal.node.service.ServiceResponseDecoderState;
import org.ros.internal.node.service.ServiceServerResponse;

class ServiceResponseDecoder<ResponseType>
extends ReplayingDecoder<ServiceResponseDecoderState> {
    private ServiceServerResponse response;

    public ServiceResponseDecoder() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, ServiceResponseDecoderState state) throws Exception {
        switch (state) {
            case ERROR_CODE: {
                this.response.setErrorCode(buffer.readByte());
                this.checkpoint(ServiceResponseDecoderState.MESSAGE_LENGTH);
            }
            case MESSAGE_LENGTH: {
                this.response.setMessageLength(buffer.readInt());
                this.checkpoint(ServiceResponseDecoderState.MESSAGE);
            }
            case MESSAGE: {
                this.response.setMessage(buffer.readBytes(this.response.getMessageLength()));
                try {
                    ServiceServerResponse serviceServerResponse = this.response;
                    return serviceServerResponse;
                }
                finally {
                    this.reset();
                }
            }
        }
        throw new IllegalStateException();
    }

    private void reset() {
        this.checkpoint(ServiceResponseDecoderState.ERROR_CODE);
        this.response = new ServiceServerResponse();
    }
}

