/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ros.concurrent.ListenerGroup;
import org.ros.concurrent.SignalRunnable;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.DefaultPublisher;
import org.ros.internal.node.topic.DefaultTopicParticipant;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.topic.SubscriberDeclaration;
import org.ros.internal.node.topic.SubscriberHandshakeHandler;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.node.topic.UpdatePublisherRunnable;
import org.ros.internal.transport.ProtocolNames;
import org.ros.internal.transport.queue.IncomingMessageQueue;
import org.ros.internal.transport.tcp.TcpClientManager;
import org.ros.message.MessageDeserializer;
import org.ros.message.MessageListener;
import org.ros.node.topic.DefaultSubscriberListener;
import org.ros.node.topic.Subscriber;
import org.ros.node.topic.SubscriberListener;

public class DefaultSubscriber<T>
extends DefaultTopicParticipant
implements Subscriber<T> {
    private static final Log log = LogFactory.getLog(DefaultPublisher.class);
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 5;
    private static final TimeUnit DEFAULT_SHUTDOWN_TIMEOUT_UNITS = TimeUnit.SECONDS;
    private final NodeIdentifier nodeIdentifier;
    private final ScheduledExecutorService executorService;
    private final IncomingMessageQueue<T> incomingMessageQueue;
    private final Set<PublisherIdentifier> knownPublishers;
    private final TcpClientManager tcpClientManager;
    private final Object mutex;
    private final ListenerGroup<SubscriberListener<T>> subscriberListeners;

    public static <S> DefaultSubscriber<S> newDefault(NodeIdentifier nodeIdentifier, TopicDeclaration description, ScheduledExecutorService executorService, MessageDeserializer<S> deserializer) {
        return new DefaultSubscriber<S>(nodeIdentifier, description, deserializer, executorService);
    }

    private DefaultSubscriber(NodeIdentifier nodeIdentifier, TopicDeclaration topicDeclaration, MessageDeserializer<T> deserializer, ScheduledExecutorService executorService) {
        super(topicDeclaration);
        this.nodeIdentifier = nodeIdentifier;
        this.executorService = executorService;
        this.incomingMessageQueue = new IncomingMessageQueue<T>(deserializer, executorService);
        this.knownPublishers = Sets.newHashSet();
        this.tcpClientManager = new TcpClientManager(executorService);
        this.mutex = new Object();
        SubscriberHandshakeHandler<T> subscriberHandshakeHandler = new SubscriberHandshakeHandler<T>(this.toDeclaration().toConnectionHeader(), this.incomingMessageQueue, executorService);
        this.tcpClientManager.addNamedChannelHandler(subscriberHandshakeHandler);
        this.subscriberListeners = new ListenerGroup(executorService);
        this.subscriberListeners.add(new DefaultSubscriberListener<T>(){

            @Override
            public void onMasterRegistrationSuccess(Subscriber<T> registrant) {
                log.info((Object)("Subscriber registered: " + DefaultSubscriber.this));
            }

            @Override
            public void onMasterRegistrationFailure(Subscriber<T> registrant) {
                log.info((Object)("Subscriber registration failed: " + DefaultSubscriber.this));
            }

            @Override
            public void onMasterUnregistrationSuccess(Subscriber<T> registrant) {
                log.info((Object)("Subscriber unregistered: " + DefaultSubscriber.this));
            }

            @Override
            public void onMasterUnregistrationFailure(Subscriber<T> registrant) {
                log.info((Object)("Subscriber unregistration failed: " + DefaultSubscriber.this));
            }
        });
    }

    public SubscriberIdentifier toIdentifier() {
        return new SubscriberIdentifier(this.nodeIdentifier, this.getTopicDeclaration().getIdentifier());
    }

    public SubscriberDeclaration toDeclaration() {
        return new SubscriberDeclaration(this.toIdentifier(), this.getTopicDeclaration());
    }

    public Collection<String> getSupportedProtocols() {
        return ProtocolNames.SUPPORTED;
    }

    @Override
    public boolean getLatchMode() {
        return this.incomingMessageQueue.getLatchMode();
    }

    @Override
    public void addMessageListener(MessageListener<T> messageListener, int limit) {
        this.incomingMessageQueue.addListener(messageListener, limit);
    }

    @Override
    public void addMessageListener(MessageListener<T> messageListener) {
        this.addMessageListener(messageListener, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void addPublisher(PublisherIdentifier publisherIdentifier, InetSocketAddress address) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.knownPublishers.contains(publisherIdentifier)) {
                return;
            }
            this.tcpClientManager.connect(this.toString(), address);
            this.knownPublishers.add(publisherIdentifier);
            this.signalOnNewPublisher(publisherIdentifier);
        }
    }

    public void updatePublishers(Collection<PublisherIdentifier> publisherIdentifiers) {
        for (PublisherIdentifier publisherIdentifier : publisherIdentifiers) {
            this.executorService.execute(new UpdatePublisherRunnable(this, this.nodeIdentifier, publisherIdentifier));
        }
    }

    @Override
    public void shutdown(long timeout, TimeUnit unit) {
        this.signalOnShutdown(timeout, unit);
        this.incomingMessageQueue.shutdown();
        this.tcpClientManager.shutdown();
        this.subscriberListeners.shutdown();
    }

    @Override
    public void shutdown() {
        this.shutdown(5L, DEFAULT_SHUTDOWN_TIMEOUT_UNITS);
    }

    @Override
    public void addSubscriberListener(SubscriberListener<T> listener) {
        this.subscriberListeners.add(listener);
    }

    @Override
    public void signalOnMasterRegistrationSuccess() {
        final DefaultSubscriber subscriber = this;
        this.subscriberListeners.signal(new SignalRunnable<SubscriberListener<T>>(){

            @Override
            public void run(SubscriberListener<T> listener) {
                listener.onMasterRegistrationSuccess(subscriber);
            }
        });
    }

    @Override
    public void signalOnMasterRegistrationFailure() {
        final DefaultSubscriber subscriber = this;
        this.subscriberListeners.signal(new SignalRunnable<SubscriberListener<T>>(){

            @Override
            public void run(SubscriberListener<T> listener) {
                listener.onMasterRegistrationFailure(subscriber);
            }
        });
    }

    @Override
    public void signalOnMasterUnregistrationSuccess() {
        final DefaultSubscriber subscriber = this;
        this.subscriberListeners.signal(new SignalRunnable<SubscriberListener<T>>(){

            @Override
            public void run(SubscriberListener<T> listener) {
                listener.onMasterUnregistrationSuccess(subscriber);
            }
        });
    }

    @Override
    public void signalOnMasterUnregistrationFailure() {
        final DefaultSubscriber subscriber = this;
        this.subscriberListeners.signal(new SignalRunnable<SubscriberListener<T>>(){

            @Override
            public void run(SubscriberListener<T> listener) {
                listener.onMasterUnregistrationFailure(subscriber);
            }
        });
    }

    public void signalOnNewPublisher(final PublisherIdentifier publisherIdentifier) {
        final DefaultSubscriber subscriber = this;
        this.subscriberListeners.signal(new SignalRunnable<SubscriberListener<T>>(){

            @Override
            public void run(SubscriberListener<T> listener) {
                listener.onNewPublisher(subscriber, publisherIdentifier);
            }
        });
    }

    private void signalOnShutdown(long timeout, TimeUnit unit) {
        final DefaultSubscriber subscriber = this;
        try {
            this.subscriberListeners.signal(new SignalRunnable<SubscriberListener<T>>(){

                @Override
                public void run(SubscriberListener<T> listener) {
                    listener.onShutdown(subscriber);
                }
            }, timeout, unit);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    public String toString() {
        return "Subscriber<" + this.getTopicDeclaration() + ">";
    }
}

