/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class PublisherDeclaration {
    private final PublisherIdentifier publisherIdentifier;
    private final TopicDeclaration topicDeclaration;

    public static PublisherDeclaration newFromNodeIdentifier(NodeIdentifier nodeIdentifier, TopicDeclaration topicDeclaration) {
        Preconditions.checkNotNull((Object)nodeIdentifier);
        Preconditions.checkNotNull((Object)topicDeclaration);
        return new PublisherDeclaration(new PublisherIdentifier(nodeIdentifier, topicDeclaration.getIdentifier()), topicDeclaration);
    }

    public PublisherDeclaration(PublisherIdentifier publisherIdentifier, TopicDeclaration topicDeclaration) {
        Preconditions.checkNotNull((Object)publisherIdentifier);
        Preconditions.checkNotNull((Object)topicDeclaration);
        Preconditions.checkArgument((boolean)publisherIdentifier.getTopicIdentifier().equals(topicDeclaration.getIdentifier()));
        this.publisherIdentifier = publisherIdentifier;
        this.topicDeclaration = topicDeclaration;
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = this.publisherIdentifier.toConnectionHeader();
        connectionHeader.merge(this.topicDeclaration.toConnectionHeader());
        return connectionHeader;
    }

    public NodeIdentifier getSlaveIdentifier() {
        return this.publisherIdentifier.getNodeIdentifier();
    }

    public GraphName getSlaveName() {
        return this.publisherIdentifier.getNodeIdentifier().getName();
    }

    public URI getSlaveUri() {
        return this.publisherIdentifier.getNodeUri();
    }

    public GraphName getTopicName() {
        return this.topicDeclaration.getName();
    }

    public String getTopicMessageType() {
        return this.topicDeclaration.getMessageType();
    }

    public String toString() {
        return "PublisherDefinition<" + this.publisherIdentifier + ", " + this.topicDeclaration + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.publisherIdentifier == null ? 0 : this.publisherIdentifier.hashCode());
        result = 31 * result + (this.topicDeclaration == null ? 0 : this.topicDeclaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublisherDeclaration other = (PublisherDeclaration)obj;
        if (this.publisherIdentifier == null ? other.publisherIdentifier != null : !this.publisherIdentifier.equals(other.publisherIdentifier)) {
            return false;
        }
        return !(this.topicDeclaration == null ? other.topicDeclaration != null : !this.topicDeclaration.equals(other.topicDeclaration));
    }
}

