/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import java.util.concurrent.ScheduledExecutorService;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.DefaultSubscriber;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.topic.TopicDeclaration;
import org.ros.internal.node.topic.TopicParticipantManager;
import org.ros.message.MessageDeserializer;
import org.ros.namespace.GraphName;
import org.ros.node.topic.DefaultSubscriberListener;
import org.ros.node.topic.Subscriber;

public class SubscriberFactory {
    private final NodeIdentifier nodeIdentifier;
    private final TopicParticipantManager topicParticipantManager;
    private final ScheduledExecutorService executorService;
    private final Object mutex;

    public SubscriberFactory(NodeIdentifier nodeIdentifier, TopicParticipantManager topicParticipantManager, ScheduledExecutorService executorService) {
        this.nodeIdentifier = nodeIdentifier;
        this.topicParticipantManager = topicParticipantManager;
        this.executorService = executorService;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Subscriber<T> newOrExisting(TopicDeclaration topicDeclaration, MessageDeserializer<T> messageDeserializer) {
        Object object = this.mutex;
        synchronized (object) {
            GraphName topicName = topicDeclaration.getName();
            if (this.topicParticipantManager.hasSubscriber(topicName)) {
                return this.topicParticipantManager.getSubscriber(topicName);
            }
            DefaultSubscriber<T> subscriber = DefaultSubscriber.newDefault(this.nodeIdentifier, topicDeclaration, this.executorService, messageDeserializer);
            subscriber.addSubscriberListener(new DefaultSubscriberListener<T>(){

                @Override
                public void onNewPublisher(Subscriber<T> subscriber, PublisherIdentifier publisherIdentifier) {
                    SubscriberFactory.this.topicParticipantManager.addSubscriberConnection((DefaultSubscriber)subscriber, publisherIdentifier);
                }

                @Override
                public void onShutdown(Subscriber<T> subscriber) {
                    SubscriberFactory.this.topicParticipantManager.removeSubscriber((DefaultSubscriber)subscriber);
                }
            });
            this.topicParticipantManager.addSubscriber(subscriber);
            return subscriber;
        }
    }
}

