/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.ros.internal.node.server.NodeIdentifier;
import org.ros.internal.node.topic.TopicIdentifier;
import org.ros.internal.transport.ConnectionHeader;
import org.ros.namespace.GraphName;

public class SubscriberIdentifier {
    private final NodeIdentifier nodeIdentifier;
    private final TopicIdentifier topicIdentifier;

    public SubscriberIdentifier(NodeIdentifier nodeIdentifier, TopicIdentifier topicIdentifier) {
        Preconditions.checkNotNull((Object)nodeIdentifier);
        Preconditions.checkNotNull((Object)topicIdentifier);
        this.nodeIdentifier = nodeIdentifier;
        this.topicIdentifier = topicIdentifier;
    }

    public ConnectionHeader toConnectionHeader() {
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.merge(this.nodeIdentifier.toConnectionHeader());
        connectionHeader.merge(this.topicIdentifier.toConnectionHeader());
        return connectionHeader;
    }

    public NodeIdentifier getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public URI getUri() {
        return this.nodeIdentifier.getUri();
    }

    public TopicIdentifier getTopicIdentifier() {
        return this.topicIdentifier;
    }

    public GraphName getTopicName() {
        return this.topicIdentifier.getName();
    }

    public String toString() {
        return "SubscriberIdentifier<" + this.nodeIdentifier + ", " + this.topicIdentifier + ">";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeIdentifier == null ? 0 : this.nodeIdentifier.hashCode());
        result = 31 * result + (this.topicIdentifier == null ? 0 : this.topicIdentifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriberIdentifier other = (SubscriberIdentifier)obj;
        if (this.nodeIdentifier == null ? other.nodeIdentifier != null : !this.nodeIdentifier.equals(other.nodeIdentifier)) {
            return false;
        }
        return !(this.topicIdentifier == null ? other.topicIdentifier != null : !this.topicIdentifier.equals(other.topicIdentifier));
    }
}

