/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.node.topic;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.ros.internal.node.topic.DefaultPublisher;
import org.ros.internal.node.topic.DefaultSubscriber;
import org.ros.internal.node.topic.PublisherIdentifier;
import org.ros.internal.node.topic.SubscriberIdentifier;
import org.ros.internal.node.topic.TopicParticipantManagerListener;
import org.ros.namespace.GraphName;

public class TopicParticipantManager {
    private final Map<GraphName, DefaultSubscriber<?>> subscribers;
    private final Map<GraphName, DefaultPublisher<?>> publishers = Maps.newConcurrentMap();
    private final Multimap<DefaultSubscriber<?>, PublisherIdentifier> subscriberConnections;
    private final Multimap<DefaultPublisher<?>, SubscriberIdentifier> publisherConnections;
    private TopicParticipantManagerListener listener;

    public TopicParticipantManager() {
        this.subscribers = Maps.newConcurrentMap();
        this.subscriberConnections = HashMultimap.create();
        this.publisherConnections = HashMultimap.create();
    }

    public void setListener(TopicParticipantManagerListener listener) {
        this.listener = listener;
    }

    public boolean hasSubscriber(GraphName topicName) {
        return this.subscribers.containsKey(topicName);
    }

    public boolean hasPublisher(GraphName topicName) {
        return this.publishers.containsKey(topicName);
    }

    public DefaultPublisher<?> getPublisher(GraphName topicName) {
        return this.publishers.get(topicName);
    }

    public DefaultSubscriber<?> getSubscriber(GraphName topicName) {
        return this.subscribers.get(topicName);
    }

    public void addPublisher(DefaultPublisher<?> publisher) {
        this.publishers.put(publisher.getTopicName(), publisher);
        if (this.listener != null) {
            this.listener.onPublisherAdded(publisher);
        }
    }

    public void removePublisher(DefaultPublisher<?> publisher) {
        this.publishers.remove(publisher.getTopicName());
        if (this.listener != null) {
            this.listener.onPublisherRemoved(publisher);
        }
    }

    public void addSubscriber(DefaultSubscriber<?> subscriber) {
        this.subscribers.put(subscriber.getTopicName(), subscriber);
        if (this.listener != null) {
            this.listener.onSubscriberAdded(subscriber);
        }
    }

    public void removeSubscriber(DefaultSubscriber<?> subscriber) {
        this.subscribers.remove(subscriber.getTopicName());
        if (this.listener != null) {
            this.listener.onSubscriberRemoved(subscriber);
        }
    }

    public void addSubscriberConnection(DefaultSubscriber<?> subscriber, PublisherIdentifier publisherIdentifier) {
        this.subscriberConnections.put(subscriber, (Object)publisherIdentifier);
    }

    public void removeSubscriberConnection(DefaultSubscriber<?> subscriber, PublisherIdentifier publisherIdentifier) {
        this.subscriberConnections.remove(subscriber, (Object)publisherIdentifier);
    }

    public void addPublisherConnection(DefaultPublisher<?> publisher, SubscriberIdentifier subscriberIdentifier) {
        this.publisherConnections.put(publisher, (Object)subscriberIdentifier);
    }

    public void removePublisherConnection(DefaultPublisher<?> publisher, SubscriberIdentifier subscriberIdentifier) {
        this.publisherConnections.remove(publisher, (Object)subscriberIdentifier);
    }

    public Collection<DefaultSubscriber<?>> getSubscribers() {
        return ImmutableList.copyOf(this.subscribers.values());
    }

    public Collection<PublisherIdentifier> getSubscriberConnections(DefaultSubscriber<?> subscriber) {
        return ImmutableList.copyOf((Collection)this.subscriberConnections.get(subscriber));
    }

    public Collection<DefaultPublisher<?>> getPublishers() {
        return ImmutableList.copyOf(this.publishers.values());
    }

    public Collection<SubscriberIdentifier> getPublisherConnections(DefaultPublisher<?> publisher) {
        return ImmutableList.copyOf((Collection)this.publisherConnections.get(publisher));
    }
}

