/*
 * Decompiled with CFR 0.152.
 */
package org.ros.internal.transport;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.ros.exception.RosRuntimeException;
import org.ros.internal.message.MessageBuffers;

public class ConnectionHeader {
    private static final boolean DEBUG = false;
    private static final Log log = LogFactory.getLog(ConnectionHeader.class);
    private final Map<String, String> fields = Maps.newConcurrentMap();

    public static ConnectionHeader decode(ChannelBuffer buffer) {
        String field;
        HashMap fields = Maps.newHashMap();
        int readableBytes = buffer.readableBytes();
        for (int position = 0; position < readableBytes; position += field.length()) {
            int fieldSize = buffer.readInt();
            position += 4;
            if (fieldSize == 0) {
                throw new IllegalStateException("Invalid 0 length handshake header field.");
            }
            if (position + fieldSize > readableBytes) {
                throw new IllegalStateException("Invalid line length handshake header field.");
            }
            field = ConnectionHeader.decodeAsciiString(buffer, fieldSize);
            Preconditions.checkState((field.indexOf("=") > 0 ? 1 : 0) != 0, (Object)String.format("Invalid field in handshake header: \"%s\"", field));
            String[] keyAndValue = field.split("=");
            if (keyAndValue.length == 1) {
                fields.put(keyAndValue[0], "");
                continue;
            }
            fields.put(keyAndValue[0], keyAndValue[1]);
        }
        ConnectionHeader connectionHeader = new ConnectionHeader();
        connectionHeader.mergeFields(fields);
        return connectionHeader;
    }

    private static String decodeAsciiString(ChannelBuffer buffer, int length) {
        return buffer.readBytes(length).toString(Charset.forName("US-ASCII"));
    }

    public ChannelBuffer encode() {
        ChannelBuffer buffer = MessageBuffers.dynamicBuffer();
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            String field = entry.getKey() + "=" + entry.getValue();
            buffer.writeInt(field.length());
            buffer.writeBytes(field.getBytes(Charset.forName("US-ASCII")));
        }
        return buffer;
    }

    public void merge(ConnectionHeader other) {
        Map<String, String> otherFields = other.getFields();
        this.mergeFields(otherFields);
    }

    public void mergeFields(Map<String, String> other) {
        for (Map.Entry<String, String> field : other.entrySet()) {
            String name = field.getKey();
            String value = field.getValue();
            this.addField(name, value);
        }
    }

    public void addField(String name, String value) {
        if (this.fields.containsKey(name) && !this.fields.get(name).equals(value)) {
            throw new RosRuntimeException(String.format("Unable to merge field %s: %s != %s", name, value, this.fields.get(name)));
        }
        this.fields.put(name, value);
    }

    public Map<String, String> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public boolean hasField(String name) {
        return this.fields.containsKey(name);
    }

    public String getField(String name) {
        return this.fields.get(name);
    }

    public String toString() {
        return String.format("ConnectionHeader <%s>", this.fields.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionHeader other = (ConnectionHeader)obj;
        return !(this.fields == null ? other.fields != null : !this.fields.equals(other.fields));
    }
}

