/*
 * Decompiled with CFR 0.152.
 */
package org.ros.master.uri;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ros.exception.RosRuntimeException;
import org.ros.master.uri.MasterUriProvider;

public class SwitchableMasterUriProvider
implements MasterUriProvider {
    private final Object mutex;
    private MasterUriProvider provider;
    private List<ProviderRequest> pending = Lists.newArrayList();

    public SwitchableMasterUriProvider(MasterUriProvider provider) {
        this.provider = provider;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI getMasterUri() throws RosRuntimeException {
        MasterUriProvider providerToUse = null;
        ProviderRequest requestToUse = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.provider != null) {
                providerToUse = this.provider;
            } else {
                requestToUse = new ProviderRequest();
                this.pending.add(requestToUse);
            }
        }
        if (providerToUse != null) {
            return providerToUse.getMasterUri();
        }
        return requestToUse.getMasterUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI getMasterUri(long timeout, TimeUnit unit) {
        MasterUriProvider providerToUse = null;
        Object object = this.mutex;
        synchronized (object) {
            if (this.provider != null) {
                providerToUse = this.provider;
            }
        }
        if (providerToUse != null) {
            return providerToUse.getMasterUri(timeout, unit);
        }
        try {
            Thread.sleep(unit.toMillis(timeout));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchProvider(MasterUriProviderSwitcher switcher) {
        Object object = this.mutex;
        synchronized (object) {
            MasterUriProvider oldProvider = this.provider;
            this.provider = switcher.switchProvider(oldProvider);
            if (oldProvider == null) {
                for (ProviderRequest request : this.pending) {
                    request.setProvider(this.provider);
                }
                this.pending.clear();
            }
        }
    }

    private static class ProviderRequest {
        private CountDownLatch latch = new CountDownLatch(1);
        private MasterUriProvider provider;

        private ProviderRequest() {
        }

        public URI getMasterUri() {
            try {
                this.latch.await();
                return this.provider.getMasterUri();
            }
            catch (InterruptedException e) {
                throw new RosRuntimeException("URI provider interrupted", e);
            }
        }

        public void setProvider(MasterUriProvider provider) {
            this.provider = provider;
            this.latch.countDown();
        }
    }

    public static interface MasterUriProviderSwitcher {
        public MasterUriProvider switchProvider(MasterUriProvider var1);
    }
}

