/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n.uclc;

public class DefaultCaseConverter {
    private DefaultCaseConverter() {
    }

    public static boolean isLowerCase(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= '\u00df' && ch <= '\u00f6' || ch >= '\u00f8' && ch <= '\u00ff';
    }

    public static boolean isUpperCase(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= '\u00c0' && ch <= '\u00d6' || ch >= '\u00d8' && ch <= '\u00de';
    }

    public static char toLowerCase(char ch) {
        if (DefaultCaseConverter.isUpperCase(ch)) {
            if (ch <= 'Z') {
                return (char)(ch + 32);
            }
            return (char)(ch + 32);
        }
        return ch;
    }

    public static char toUpperCase(char ch) {
        if (DefaultCaseConverter.isLowerCase(ch)) {
            if (ch <= 'z') {
                return (char)(ch - 32);
            }
            return (char)(ch - 32);
        }
        return ch;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static int digit(char ch, int radix) {
        int value = -1;
        if (radix >= 2 && radix <= 36) {
            if (DefaultCaseConverter.isDigit(ch)) {
                value = ch - 48;
            } else if (DefaultCaseConverter.isUpperCase(ch) || DefaultCaseConverter.isLowerCase(ch)) {
                value = (ch & 0x1F) + 9;
            }
        }
        return value < radix ? value : -1;
    }
}

