/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;
import com.sun.squawk.Address;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.VM;
import com.sun.squawk.VMThread;

public class Function {
    protected static final boolean DEBUG = false;
    protected final Address funcAddr;
    protected final String name;

    Function(String name, Address funcAddr) {
        this.funcAddr = funcAddr;
        this.name = name;
    }

    public static Function getFunction(String libraryName, String funcName) {
        return NativeLibrary.getInstance(libraryName).getFunction(funcName);
    }

    public static int errno() {
        return VMThread.currentThread().getErrno();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Function(" + this.name + ", " + this.funcAddr.toUWord().toInt() + ")";
    }

    protected void preamble() {
        VM.print(this.toString());
        VM.println(".call");
    }

    protected void postscript(int result) {
        VM.print("call returned: ");
        VM.print(result);
        VM.println();
    }

    public int call0() {
        int result = NativeUnsafe.call0(this.funcAddr);
        return result;
    }

    public int call1(int i1) {
        int result = NativeUnsafe.call1(this.funcAddr, i1);
        return result;
    }

    public int call2(int i1, int i2) {
        int result = NativeUnsafe.call2(this.funcAddr, i1, i2);
        return result;
    }

    public int call3(int i1, int i2, int i3) {
        int result = NativeUnsafe.call3(this.funcAddr, i1, i2, i3);
        return result;
    }

    public int call4(int i1, int i2, int i3, int i4) {
        int result = NativeUnsafe.call4(this.funcAddr, i1, i2, i3, i4);
        return result;
    }

    public int call5(int i1, int i2, int i3, int i4, int i5) {
        int result = NativeUnsafe.call5(this.funcAddr, i1, i2, i3, i4, i5);
        return result;
    }

    public int call6(int i1, int i2, int i3, int i4, int i5, int i6) {
        int result = NativeUnsafe.call6(this.funcAddr, i1, i2, i3, i4, i5, i6);
        return result;
    }

    public int call7(int i1, int i2, int i3, int i4, int i5, int i6, int i7) {
        int result = NativeUnsafe.call7(this.funcAddr, i1, i2, i3, i4, i5, i6, i7);
        return result;
    }

    public int call8(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
        int result = NativeUnsafe.call8(this.funcAddr, i1, i2, i3, i4, i5, i6, i7, i8);
        return result;
    }

    public int call9(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9) {
        int result = NativeUnsafe.call9(this.funcAddr, i1, i2, i3, i4, i5, i6, i7, i8, i9);
        return result;
    }

    public int call10(int i1, int i2, int i3, int i4, int i5, int i6, int i7, int i8, int i9, int i10) {
        int result = NativeUnsafe.call10(this.funcAddr, i1, i2, i3, i4, i5, i6, i7, i8, i9, i10);
        return result;
    }

    public int call1(Pointer p1) {
        return this.call1(p1.address().toUWord().toPrimitive());
    }

    public int call2(int i1, Pointer p2) {
        return this.call2(i1, p2.address().toUWord().toPrimitive());
    }

    public int call2(Pointer p1, int i2) {
        return this.call2(p1.address().toUWord().toPrimitive(), i2);
    }

    public int call2(Pointer p1, Pointer p2) {
        return this.call2(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive());
    }

    public int call3(int i1, int i2, Pointer p3) {
        return this.call3(i1, i2, p3.address().toUWord().toPrimitive());
    }

    public int call3(int i1, Pointer p2, int i3) {
        return this.call3(i1, p2.address().toUWord().toPrimitive(), i3);
    }

    public int call3(int i1, Pointer p2, Pointer p3) {
        return this.call3(i1, p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive());
    }

    public int call3(Pointer p1, int i2, int i3) {
        return this.call3(p1.address().toUWord().toPrimitive(), i2, i3);
    }

    public int call3(Pointer p1, int i2, Pointer p3) {
        return this.call3(p1.address().toUWord().toPrimitive(), i2, p3.address().toUWord().toPrimitive());
    }

    public int call3(Pointer p1, Pointer p2, int i3) {
        return this.call3(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), i3);
    }

    public int call3(Pointer p1, Pointer p2, Pointer p3) {
        return this.call3(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive());
    }

    public int call4(int i1, int i2, int i3, Pointer p4) {
        return this.call4(i1, i2, i3, p4.address().toUWord().toPrimitive());
    }

    public int call4(int i1, int i2, Pointer p3, int i4) {
        return this.call4(i1, i2, p3.address().toUWord().toPrimitive(), i4);
    }

    public int call4(int i1, int i2, Pointer p3, Pointer p4) {
        return this.call4(i1, i2, p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive());
    }

    public int call4(int i1, Pointer p2, int i3, int i4) {
        return this.call4(i1, p2.address().toUWord().toPrimitive(), i3, i4);
    }

    public int call4(int i1, Pointer p2, int i3, Pointer p4) {
        return this.call4(i1, p2.address().toUWord().toPrimitive(), i3, p4.address().toUWord().toPrimitive());
    }

    public int call4(int i1, Pointer p2, Pointer p3, int i4) {
        return this.call4(i1, p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), i4);
    }

    public int call4(int i1, Pointer p2, Pointer p3, Pointer p4) {
        return this.call4(i1, p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive());
    }

    public int call4(Pointer p1, int i2, int i3, int i4) {
        return this.call4(p1.address().toUWord().toPrimitive(), i2, i3, i4);
    }

    public int call4(Pointer p1, int i2, int i3, Pointer p4) {
        return this.call4(p1.address().toUWord().toPrimitive(), i2, i3, p4.address().toUWord().toPrimitive());
    }

    public int call4(Pointer p1, int i2, Pointer p3, int i4) {
        return this.call4(p1.address().toUWord().toPrimitive(), i2, p3.address().toUWord().toPrimitive(), i4);
    }

    public int call4(Pointer p1, int i2, Pointer p3, Pointer p4) {
        return this.call4(p1.address().toUWord().toPrimitive(), i2, p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive());
    }

    public int call4(Pointer p1, Pointer p2, int i3, int i4) {
        return this.call4(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), i3, i4);
    }

    public int call4(Pointer p1, Pointer p2, int i3, Pointer p4) {
        return this.call4(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), i3, p4.address().toUWord().toPrimitive());
    }

    public int call4(Pointer p1, Pointer p2, Pointer p3, int i4) {
        return this.call4(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), i4);
    }

    public int call4(Pointer p1, Pointer p2, Pointer p3, Pointer p4) {
        return this.call4(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive());
    }

    public int call5(int i1, int i2, int i3, Pointer p4, int i5) {
        return this.call5(i1, i2, i3, p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(int i1, int i2, Pointer p3, int i4, int i5) {
        return this.call5(i1, i2, p3.address().toUWord().toPrimitive(), i4, i5);
    }

    public int call5(int i1, int i2, Pointer p3, Pointer p4, int i5) {
        return this.call5(i1, i2, p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(int i1, Pointer p2, int i3, int i4, int i5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), i3, i4, i5);
    }

    public int call5(int i1, Pointer p2, int i3, Pointer p4, int i5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), i3, p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(int i1, Pointer p2, Pointer p3, int i4, int i5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), i4, i5);
    }

    public int call5(int i1, Pointer p2, Pointer p3, Pointer p4, int i5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(Pointer p1, int i2, int i3, int i4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, i3, i4, i5);
    }

    public int call5(Pointer p1, int i2, int i3, Pointer p4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, i3, p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(Pointer p1, int i2, Pointer p3, int i4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, p3.address().toUWord().toPrimitive(), i4, i5);
    }

    public int call5(Pointer p1, int i2, Pointer p3, Pointer p4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(Pointer p1, Pointer p2, int i3, int i4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), i3, i4, i5);
    }

    public int call5(Pointer p1, Pointer p2, int i3, Pointer p4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), i3, p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(Pointer p1, Pointer p2, Pointer p3, int i4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), i4, i5);
    }

    public int call5(Pointer p1, Pointer p2, Pointer p3, Pointer p4, int i5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), i5);
    }

    public int call5(int i1, int i2, int i3, int i4, int i5, Pointer p5) {
        return this.call5(i1, i2, i3, i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(int i1, int i2, int i3, Pointer p4, Pointer p5) {
        return this.call5(i1, i2, i3, p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public int call5(int i1, int i2, Pointer p3, int i4, Pointer p5) {
        return this.call5(i1, i2, p3.address().toUWord().toPrimitive(), i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(int i1, int i2, Pointer p3, Pointer p4, Pointer p5) {
        return this.call5(i1, i2, p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public int call5(int i1, Pointer p2, int i3, int i4, Pointer p5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), i3, i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(int i1, Pointer p2, int i3, Pointer p4, Pointer p5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), i3, p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public int call5(int i1, Pointer p2, Pointer p3, int i4, Pointer p5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(int i1, Pointer p2, Pointer p3, Pointer p4, Pointer p5) {
        return this.call5(i1, p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, int i2, int i3, int i4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, i3, i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, int i2, int i3, Pointer p4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, i3, p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, int i2, Pointer p3, int i4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, p3.address().toUWord().toPrimitive(), i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, int i2, Pointer p3, Pointer p4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), i2, p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, Pointer p2, int i3, int i4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), i3, i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, Pointer p2, int i3, Pointer p4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), i3, p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, Pointer p2, Pointer p3, int i4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), i4, p5.address().toUWord().toPrimitive());
    }

    public int call5(Pointer p1, Pointer p2, Pointer p3, Pointer p4, Pointer p5) {
        return this.call5(p1.address().toUWord().toPrimitive(), p2.address().toUWord().toPrimitive(), p3.address().toUWord().toPrimitive(), p4.address().toUWord().toPrimitive(), p5.address().toUWord().toPrimitive());
    }

    public static Structure returnStruct(Class klass, int ptr) {
        Address addr = Address.fromPrimitive(ptr);
        if (addr.isZero()) {
            return null;
        }
        try {
            Structure result = (Structure)klass.newInstance();
            result.useMemory(new Pointer(addr, result.size()));
            result.read();
            return result;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public static String returnString(int ptr) {
        Address addr = Address.fromPrimitive(ptr);
        return Pointer.NativeUnsafeGetString(addr);
    }
}

