/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.jna;

import com.sun.squawk.Address;
import com.sun.squawk.GC;
import com.sun.squawk.NativeUnsafe;
import com.sun.squawk.UWord;
import com.sun.squawk.Unsafe;
import com.sun.squawk.VM;
import com.sun.squawk.realtime.OffsetOutOfBoundsException;
import com.sun.squawk.realtime.RawMemoryFloatAccess;
import com.sun.squawk.realtime.SizeOutOfBoundsException;

public class Pointer
extends RawMemoryFloatAccess {
    private static Pointer NULL;

    public static synchronized Pointer NULL() {
        if (NULL == null) {
            NULL = new Pointer(0L, 0);
        }
        return NULL;
    }

    public Pointer(int size) throws SizeOutOfBoundsException, OutOfMemoryError {
        super(null, size);
    }

    public Pointer(long base, int size) {
        super(null, base, size);
    }

    public Pointer(Address base, UWord size) {
        super(null, (long)base.toUWord().toPrimitive() & 0xFFFFFFFFL, size.toPrimitive());
    }

    public Pointer(Address base, int size) {
        super(null, (long)base.toUWord().toPrimitive() & 0xFFFFFFFFL, size);
    }

    public Pointer share(long offset) {
        return new Pointer(this, (int)offset, (int)((long)this.getSize() - offset));
    }

    public Pointer share(long offset, long size) {
        return new Pointer(this, (int)offset, (int)size);
    }

    boolean isPowerOf2(int value) {
        return (value & value - 1) == 0;
    }

    public Pointer align(int byteAlignment) {
        if (!this.isPowerOf2(byteAlignment)) {
            throw new IllegalArgumentException();
        }
        Address originalBase = this.address();
        Address newBase = originalBase.roundUp(byteAlignment);
        long offset = newBase.diff(originalBase).toPrimitive();
        return new Pointer(this, (int)offset, (int)((long)this.getSize() - offset));
    }

    public String toString() {
        Address addr = this.getAddress();
        if (addr.isZero()) {
            return "Pointer(null)";
        }
        return "Pointer(0x" + Integer.toHexString(addr.toUWord().toPrimitive()) + ", " + this.getSize() + ")";
    }

    Pointer(Pointer base, int offset, int size) {
        super(base, offset, size);
    }

    public final Address address() {
        return this.getAddress();
    }

    public final int getSize() {
        return this.size().toInt();
    }

    public void clear(int size) {
        Address addr = this.getAddress();
        if (this.size().lo(UWord.fromPrimitive(size))) {
            throw new IllegalArgumentException();
        }
        if (addr.isZero()) {
            throw new IllegalStateException();
        }
        VM.setBytes(addr, (byte)0, size);
    }

    public void clear() {
        Address addr = this.getAddress();
        if (addr.isZero()) {
            throw new IllegalStateException();
        }
        VM.setBytes(addr, (byte)0, this.getSize());
    }

    public Pointer getPointer(int offset, int size) {
        Address ptr = Address.fromPrimitive(this.getInt(offset));
        if (ptr.isZero()) {
            return null;
        }
        return new Pointer(ptr, size);
    }

    public void setPointer(int offset, Pointer ptr) {
        this.setInt(offset, ptr.getAddress().toUWord().toPrimitive());
    }

    public String getString(int offset) {
        int len = 0;
        while (this.getByte(offset + len) != 0) {
            ++len;
        }
        byte[] data = new byte[len];
        this.getBytes(offset, data, 0, len);
        return new String(data);
    }

    public static String NativeUnsafeGetString(Address cstr) {
        int len = 0;
        while (Unsafe.getByte(cstr, len) != 0) {
            ++len;
        }
        byte[] data = new byte[len];
        Unsafe.getBytes(cstr, 0, data, 0, len);
        return new String(data);
    }

    public final void setString(int offset, String value) {
        if (GC.getKlass(value).getSystemID() == 26) {
            int len = value.length();
            this.checkMultiWrite(offset, len + 1, 1);
            VM.setData(this.getAddress(), offset, value, 0, len, 1);
            this.setByte(len, (byte)0);
        } else {
            this.setString(offset, value.getBytes());
        }
    }

    private final void setString(int offset, byte[] data) {
        int len = data.length;
        this.checkMultiWrite(offset, len + 1, 1);
        this.setBytes(offset, data, 0, len);
        this.setByte(len, (byte)0);
    }

    public final void free() throws IllegalStateException {
        Address addr = this.getAddress();
        if (addr.isZero()) {
            throw new IllegalStateException();
        }
        if (!this.wasMalloced()) {
            throw new IllegalStateException("not malloced");
        }
        NativeUnsafe.free(addr);
        this.invalidate();
    }

    public final void release() throws IllegalStateException {
        Address addr = this.getAddress();
        if (addr.isZero()) {
            throw new IllegalStateException();
        }
        if (this.wasMalloced()) {
            NativeUnsafe.free(addr);
        }
        this.invalidate();
    }

    public final boolean isValid() {
        return !this.address().isZero();
    }

    public static Pointer createStringBuffer(String value) throws OutOfMemoryError {
        if (GC.getKlass(value).getSystemID() == 26) {
            Pointer result = new Pointer(value.length() + 1);
            result.setString(0, value);
            return result;
        }
        byte[] data = value.getBytes();
        Pointer result = new Pointer(data.length + 1);
        result.setString(0, data);
        return result;
    }

    private static Address getPtrToArray(byte[] array, int offset, int len) {
        int alen = array.length;
        if (offset < 0 || offset + len > alen) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return Address.fromObject(array).add(offset);
    }

    public static void copyBytes(Pointer src, int srcOffset, Pointer dst, int dstOffset, int len) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        dst.checkMultiWrite(dstOffset, len, 1);
        src.checkMultiRead(srcOffset, len, 1);
        VM.copyBytes(src.address(), srcOffset, dst.address(), dstOffset, len, false);
    }

    static void checkMultiBounds1(int length, int offset, int number, int elemsize) throws OffsetOutOfBoundsException, SizeOutOfBoundsException {
        Pointer.checkMultiBounds(length, offset, number, elemsize);
    }
}

